/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.recaptcha.validation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.mkopylec.recaptcha.validation.ErrorCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ValidationResult {
    private boolean success;
    private List<ErrorCode> errorCodes;

    @JsonCreator
    public ValidationResult(@JsonProperty(value="success") boolean success, @JsonProperty(value="error-codes") List<ErrorCode> errorCodes) {
        this.success = success;
        this.errorCodes = errorCodes == null ? new ArrayList() : errorCodes;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @JsonIgnore
    public boolean isFailure() {
        return !this.success;
    }

    public List<ErrorCode> getErrorCodes() {
        return Collections.unmodifiableList(this.errorCodes);
    }

    public boolean hasError(ErrorCode error) {
        return this.errorCodes.contains((Object)error);
    }

    public String toString() {
        return "ValidationResult{success=" + this.success + ", errorCodes=" + this.errorCodes + '}';
    }
}

