/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.recaptcha.security.login;

import com.github.mkopylec.recaptcha.security.RecaptchaAuthenticationException;
import com.github.mkopylec.recaptcha.security.login.LoginFailuresManager;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.web.util.UriComponentsBuilder;

public class RecaptchaAwareRedirectStrategy
extends DefaultRedirectStrategy {
    public static final String RECAPTCHA_ERROR_PARAMETER_NAME = "recaptchaError";
    public static final String SHOW_RECAPTCHA_QUERY_PARAM = "showRecaptcha";
    protected final LoginFailuresManager failuresManager;

    public RecaptchaAwareRedirectStrategy(LoginFailuresManager failuresManager) {
        this.failuresManager = failuresManager;
    }

    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        UriComponentsBuilder urlBuilder = UriComponentsBuilder.fromUriString((String)url);
        AuthenticationException exception = this.getAuthenticationException(request);
        if (exception instanceof RecaptchaAuthenticationException) {
            urlBuilder.queryParam(RECAPTCHA_ERROR_PARAMETER_NAME, new Object[0]);
        } else {
            urlBuilder.queryParam("error", new Object[0]);
        }
        if (this.failuresManager.isRecaptchaRequired(request)) {
            urlBuilder.queryParam(SHOW_RECAPTCHA_QUERY_PARAM, new Object[0]);
        }
        super.sendRedirect(request, response, urlBuilder.build(true).toUriString());
    }

    protected AuthenticationException getAuthenticationException(HttpServletRequest request) {
        Object exception = request.getSession(false).getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        if (exception == null) {
            exception = request.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        }
        if (exception == null) {
            throw new IllegalStateException("Missing SPRING_SECURITY_LAST_EXCEPTION session or request attribute");
        }
        return (AuthenticationException)exception;
    }
}

