/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.recaptcha.security.login;

import com.github.mkopylec.recaptcha.RecaptchaProperties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoginFailuresManager {
    private static final Logger log = LoggerFactory.getLogger(LoginFailuresManager.class);
    protected final RecaptchaProperties.Security security;
    protected String usernameParameter;

    public LoginFailuresManager(RecaptchaProperties recaptcha) {
        this.security = recaptcha.getSecurity();
    }

    public abstract void addLoginFailure(HttpServletRequest var1);

    public abstract int getLoginFailuresCount(HttpServletRequest var1);

    public abstract void clearLoginFailures(HttpServletRequest var1);

    public boolean isRecaptchaRequired(HttpServletRequest request) {
        boolean recaptchaRequired = this.getLoginFailuresCount(request) >= this.security.getLoginFailuresThreshold();
        log.debug("Done checking is reCAPTCHA required for username: {}. Check result: {}", (Object)this.getUsername(request), (Object)recaptchaRequired);
        return recaptchaRequired;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    protected String getUsername(HttpServletRequest request) {
        if (this.usernameParameter == null) {
            throw new IllegalStateException("Missing username parameter name");
        }
        String username = request.getParameter(this.usernameParameter);
        if (username == null) {
            throw new IllegalStateException("Missing username parameter '" + this.usernameParameter + "' value in HTTP request");
        }
        return username;
    }
}

