/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.recaptcha.security.login;

import com.github.mkopylec.recaptcha.security.RecaptchaAuthenticationFilter;
import com.github.mkopylec.recaptcha.security.login.LoginFailuresClearingHandler;
import com.github.mkopylec.recaptcha.security.login.LoginFailuresCountingHandler;
import java.lang.reflect.Field;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.ReflectionUtils;

public class FormLoginConfigurerEnhancer {
    public static final String DEFAULT_USERNAME_PARAMETER = "username";
    protected static final String AUTHENTICATION_PROCESSING_FILTER_FIELD = "authFilter";
    protected final RecaptchaAuthenticationFilter authenticationFilter;
    protected final LoginFailuresClearingHandler successHandler;
    protected final LoginFailuresCountingHandler failureHandler;

    public FormLoginConfigurerEnhancer(RecaptchaAuthenticationFilter authenticationFilter, LoginFailuresClearingHandler successHandler, LoginFailuresCountingHandler failureHandler) {
        this.authenticationFilter = authenticationFilter;
        this.successHandler = successHandler;
        this.failureHandler = failureHandler;
    }

    public FormLoginConfigurer<HttpSecurity> addRecaptchaSupport(FormLoginConfigurer<HttpSecurity> loginConfigurer) {
        Field authFilterField = ReflectionUtils.findField(loginConfigurer.getClass(), (String)AUTHENTICATION_PROCESSING_FILTER_FIELD, AbstractAuthenticationProcessingFilter.class);
        ReflectionUtils.makeAccessible((Field)authFilterField);
        ReflectionUtils.setField((Field)authFilterField, loginConfigurer, (Object)((Object)this.authenticationFilter));
        return (FormLoginConfigurer)((FormLoginConfigurer)loginConfigurer.usernameParameter(DEFAULT_USERNAME_PARAMETER).successHandler((AuthenticationSuccessHandler)this.successHandler)).failureHandler((AuthenticationFailureHandler)this.failureHandler);
    }
}

