/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.recaptcha.security;

import com.github.mkopylec.recaptcha.RecaptchaProperties;
import com.github.mkopylec.recaptcha.security.RecaptchaAuthenticationException;
import com.github.mkopylec.recaptcha.security.login.LoginFailuresClearingHandler;
import com.github.mkopylec.recaptcha.security.login.LoginFailuresCountingHandler;
import com.github.mkopylec.recaptcha.security.login.LoginFailuresManager;
import com.github.mkopylec.recaptcha.validation.ErrorCode;
import com.github.mkopylec.recaptcha.validation.RecaptchaValidationException;
import com.github.mkopylec.recaptcha.validation.RecaptchaValidator;
import com.github.mkopylec.recaptcha.validation.ValidationResult;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.util.Assert;

public class RecaptchaAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(RecaptchaAuthenticationFilter.class);
    protected final RecaptchaValidator recaptchaValidator;
    protected final RecaptchaProperties recaptcha;
    protected final LoginFailuresManager failuresManager;

    public RecaptchaAuthenticationFilter(RecaptchaValidator recaptchaValidator, RecaptchaProperties recaptcha, LoginFailuresManager failuresManager) {
        this.recaptchaValidator = recaptchaValidator;
        this.recaptcha = recaptcha;
        this.failuresManager = failuresManager;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        block5: {
            if (this.getUsernameParameter() == null) {
                throw new RecaptchaAuthenticationException(Collections.singletonList(ErrorCode.MISSING_USERNAME_REQUEST_PARAMETER));
            }
            if (this.failuresManager.isRecaptchaRequired(request)) {
                try {
                    String recaptchaResponse = this.obtainRecaptchaResponse(request);
                    ValidationResult result = this.recaptchaValidator.validate(recaptchaResponse, request);
                    if (result.isFailure()) {
                        throw new RecaptchaAuthenticationException(result.getErrorCodes());
                    }
                }
                catch (RecaptchaValidationException ex) {
                    boolean continueAuthentication = this.recaptcha.getSecurity().isContinueOnValidationHttpError();
                    log.error("reCAPTCHA validation HTTP error. Continuing user authentication: " + continueAuthentication, (Throwable)ex);
                    if (continueAuthentication) break block5;
                    throw new RecaptchaAuthenticationException(Collections.singletonList(ErrorCode.VALIDATION_HTTP_ERROR));
                }
            }
        }
        return super.attemptAuthentication(request, response);
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler successHandler) {
        if (!LoginFailuresClearingHandler.class.isAssignableFrom(successHandler.getClass())) {
            throw new IllegalArgumentException("Invalid login success handler. Handler must be an instance of " + LoginFailuresClearingHandler.class.getName() + " but is " + successHandler);
        }
        super.setAuthenticationSuccessHandler(successHandler);
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler failureHandler) {
        if (!LoginFailuresCountingHandler.class.isAssignableFrom(failureHandler.getClass())) {
            throw new IllegalArgumentException("Invalid login failure handler. Handler must be an instance of " + LoginFailuresCountingHandler.class.getName() + " but is " + failureHandler);
        }
        super.setAuthenticationFailureHandler(failureHandler);
    }

    public void setUsernameParameter(String usernameParameter) {
        super.setUsernameParameter(usernameParameter);
        this.failuresManager.setUsernameParameter(usernameParameter);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.recaptchaValidator, (String)"Missing recaptcha validator");
        Assert.notNull((Object)this.recaptcha, (String)"Missing recaptcha validation configuration properties");
        Assert.notNull((Object)this.failuresManager, (String)"Missing login failure manager");
    }

    protected String obtainRecaptchaResponse(HttpServletRequest request) {
        return request.getParameter(this.recaptcha.getValidation().getResponseParameter());
    }
}

