/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner.parallel;

import java.util.ArrayList;
import java.util.List;

public final class CucumberRunnerThreadPool {
    private static final int MILLS_PER_SECOND = 1000;
    private static CucumberRunnerThreadPool instance;
    private int maxCapacity = 1;
    private List<Thread> threadList = new ArrayList<Thread>();

    private CucumberRunnerThreadPool() {
    }

    public boolean push(Thread thread) throws Exception {
        this.waitAvailable();
        thread.start();
        this.getThreadList().add(thread);
        return true;
    }

    public boolean isEmpty() {
        return this.isAvailable() && this.getThreadList().size() <= 0;
    }

    public boolean isAvailable() {
        if (this.maxCapacity < 1) {
            return false;
        }
        for (int i = 0; i < this.getThreadList().size(); ++i) {
            if (this.getThreadList().get(i).isAlive()) continue;
            this.getThreadList().remove(i);
            --i;
        }
        return this.getThreadList().size() < this.getMaxCapacity();
    }

    public void waitAvailable() throws InterruptedException {
        while (!this.isAvailable()) {
            Thread.sleep(1000L);
        }
    }

    public void waitEmpty() throws InterruptedException {
        while (!this.isEmpty()) {
            Thread.sleep(1000L);
        }
    }

    public List<Thread> getThreadList() {
        return this.threadList;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacityValue) {
        this.maxCapacity = maxCapacityValue;
    }

    public static CucumberRunnerThreadPool get() {
        if (instance == null) {
            instance = new CucumberRunnerThreadPool();
        }
        return instance;
    }

    public static void setCapacity(int value) {
        CucumberRunnerThreadPool.get().setMaxCapacity(value);
    }
}

