/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner;

import com.github.mkolisnyk.cucumber.runner.ExtendedCucumber;
import com.github.mkolisnyk.cucumber.runner.ExtendedExecutionUnitRunner;
import cucumber.runtime.Runtime;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberExamples;
import cucumber.runtime.model.CucumberScenario;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public class ExtendedExamplesRunner
extends Suite {
    private int retryCount;
    private Runtime runtime;
    private Method[] retryMethods;
    private int failedAttempts = 0;
    private int scenarioCount = 0;
    private final CucumberExamples cucumberExamples;
    private Description description;
    private JUnitReporter jUnitReporter;
    private static List<Runner> runners;
    private static List<CucumberScenario> exampleScenarios;

    protected ExtendedExamplesRunner(Runtime runtimeValue, CucumberExamples cucumberExamplesValue, JUnitReporter jUnitReporterValue, int retryCountValue, Method[] retryMethodsValue) throws InitializationError {
        super(ExtendedExamplesRunner.class, ExtendedExamplesRunner.buildRunners(runtimeValue, cucumberExamplesValue, jUnitReporterValue));
        this.cucumberExamples = cucumberExamplesValue;
        this.jUnitReporter = jUnitReporterValue;
        this.runtime = runtimeValue;
        this.retryCount = retryCountValue;
        this.retryMethods = retryMethodsValue;
    }

    private static List<Runner> buildRunners(Runtime runtime, CucumberExamples cucumberExamples, JUnitReporter jUnitReporter) {
        runners = new ArrayList<Runner>();
        exampleScenarios = cucumberExamples.createExampleScenarios();
        for (CucumberScenario scenario : exampleScenarios) {
            try {
                ExtendedExecutionUnitRunner exampleScenarioRunner = new ExtendedExecutionUnitRunner(runtime, scenario, jUnitReporter);
                runners.add((Runner)exampleScenarioRunner);
            }
            catch (InitializationError initializationError) {
                initializationError.printStackTrace();
            }
        }
        return runners;
    }

    public final Runtime getRuntime() {
        return this.runtime;
    }

    protected String getName() {
        return this.cucumberExamples.getExamples().getKeyword() + ": " + this.cucumberExamples.getExamples().getName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)this.cucumberExamples.getExamples(), (Annotation[])new Annotation[0]);
            for (Runner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }

    public void run(RunNotifier notifier) {
        this.jUnitReporter.examples(this.cucumberExamples.getExamples());
        super.run(notifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(Runner runner, RunNotifier notifier) {
        ExtendedExecutionUnitRunner featureElementRunner = (ExtendedExecutionUnitRunner)runner;
        try {
            featureElementRunner = new ExtendedExecutionUnitRunner(this.runtime, ((ExtendedExecutionUnitRunner)runner).getCucumberScenario(), this.jUnitReporter);
            featureElementRunner.run(notifier);
            Assert.assertEquals((long)0L, (long)this.getRuntime().exitStatus());
        }
        catch (AssumptionViolatedException e) {
            System.out.println("Scenario AssumptionViolatedException...");
        }
        catch (Throwable e) {
            System.out.println(((ExtendedExecutionUnitRunner)runner).getCucumberScenario().getGherkinModel().getId());
            System.out.println(e.getClass().getCanonicalName() + ":" + e.getMessage());
            List errors = this.getRuntime().getErrors();
            Throwable error = (Throwable)errors.get(errors.size() - 1);
            if (ExtendedCucumber.isRetryApplicable(error, this.retryMethods)) {
                System.out.println("===Initiating retry...");
                this.retry(notifier, (ParentRunner)featureElementRunner, e);
            }
        }
        finally {
            System.out.println(((ExtendedExecutionUnitRunner)runner).getCucumberScenario().getGherkinModel().getId() + "Scenario completed..." + this.getRuntime().exitStatus());
        }
        this.setScenarioCount(this.getScenarioCount() + 1);
        this.setFailedAttempts(0);
    }

    private CucumberScenario getCurrentScenario(Runner runner) {
        return ((ExtendedExecutionUnitRunner)runner).getCucumberScenario();
    }

    public void retry(RunNotifier notifier, ParentRunner child, Throwable currentThrowable) {
        ExtendedExecutionUnitRunner featureElementRunner = null;
        Class<?> clazz = child.getClass();
        System.out.println("Current class is: " + clazz.getCanonicalName());
        CucumberScenario scenario = this.getCurrentScenario((Runner)child);
        if (scenario == null) {
            return;
        }
        this.runtime.getErrors().clear();
        while (this.getRetryCount() > this.getFailedAttempts()) {
            try {
                featureElementRunner = new ExtendedExecutionUnitRunner(this.runtime, scenario, this.jUnitReporter);
                featureElementRunner.run(notifier);
                Assert.assertEquals((long)0L, (long)this.runtime.exitStatus());
                this.runtime.getErrors().clear();
                return;
            }
            catch (Throwable t) {
                this.setFailedAttempts(this.getFailedAttempts() + 1);
                this.runtime.getErrors().clear();
            }
        }
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getFailedAttempts() {
        return this.failedAttempts;
    }

    public void setFailedAttempts(int failedAttemptsValue) {
        this.failedAttempts = failedAttemptsValue;
    }

    public int getScenarioCount() {
        return this.scenarioCount;
    }

    public void setScenarioCount(int scenarioCountValue) {
        this.scenarioCount = scenarioCountValue;
    }
}

