/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner.runtime;

import com.github.mkolisnyk.cucumber.runner.ExtendedCucumberOptions;
import gherkin.util.FixJava;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ExtendedRuntimeOptions {
    private static final String USAGE_RESOURCE = "cli_params.txt";
    private static String usageText;
    private boolean isOverviewReport = false;
    private boolean isOverviewChartsReport = false;
    private boolean isUsageReport = false;
    private boolean isDetailedReport = false;
    private boolean isDetailedAggregatedReport = false;
    private boolean isCoverageReport = false;
    private String[] jsonReportPaths;
    private String outputFolder;
    private String reportPrefix;
    private int retryCount = 0;
    private String screenShotSize = "";
    private boolean toPDF = false;
    private String pdfPageSize = "auto";
    private String[] jsonUsageReportPaths;
    private String screenShotLocation = "";
    private String[] includeCoverageTags = new String[0];
    private String[] excludeCoverageTags = new String[0];
    private boolean breakdownReport = false;
    private String breakdownConfig = "";
    private boolean featureMapReport = false;
    private String featureMapConfig = "";
    private boolean featureOverviewChart = false;
    private boolean knownErrorsReport = false;
    private String knownErrorsConfig = "";
    private boolean consolidatedReport = false;
    private String consolidatedReportConfig = "";
    private int threadsCount;
    private String threadsCountValue;
    private boolean systemInfoReport = false;
    private boolean benchmarkReport = false;
    private String benchmarkReportConfig = "";
    private boolean customReport = false;
    private String[] customReportTemplateNames = new String[0];
    private String customTemplatesPath = "";
    private String[] formats = new String[0];

    private String[] joinPaths(String singlePath, String[] arrayPath) {
        Object[] result = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)singlePath)) {
            result = (String[])ArrayUtils.add((Object[])result, (Object)singlePath);
        }
        if (arrayPath != null && arrayPath.length > 0) {
            result = (String[])ArrayUtils.addAll((Object[])result, (Object[])arrayPath);
        }
        return result;
    }

    public void processParameters() {
        if (!this.isToPDF()) {
            this.formats = (String[])ArrayUtils.removeElement((Object[])this.formats, (Object)"pdf");
        } else if (!ArrayUtils.contains((Object[])this.formats, (Object)"pdf")) {
            this.formats = (String[])ArrayUtils.add((Object[])this.formats, (Object)"pdf");
        }
    }

    public ExtendedRuntimeOptions() {
    }

    public ExtendedRuntimeOptions(List<String> args) throws Exception {
        HashMap<String, String> singleValueMap = new HashMap<String, String>(){
            {
                this.put("-o", "outputFolder");
                this.put("--out-folder", "outputFolder");
                this.put("-rp", "reportPrefix");
                this.put("--report-prefix", "reportPrefix");
                this.put("-ss", "screenShotSize");
                this.put("--screenshot-size", "screenShotSize");
                this.put("-ps", "pdfPageSize");
                this.put("-pdf-page-size", "pdfPageSize");
                this.put("-sl", "screenShotLocation");
                this.put("--screenshot-location", "screenShotLocation");
                this.put("-bc", "breakdownConfig");
                this.put("--breakdown-config", "breakdownConfig");
                this.put("-fmc", "featureMapConfig");
                this.put("--feature-map-config", "featureMapConfig");
                this.put("-kec", "knownErrorsConfig");
                this.put("--known-errors-config", "knownErrorsConfig");
                this.put("-crc", "consolidatedReportConfig");
                this.put("--consolidated-report-config", "consolidatedReportConfig");
                this.put("-ctp", "customTemplatesPath");
                this.put("--custom-templates-path", "customTemplatesPath");
            }
        };
        HashMap<String, String> multiValueMap = new HashMap<String, String>(){
            {
                this.put("-jrp", "jsonReportPaths");
                this.put("--json-report-path", "jsonReportPaths");
                this.put("-urp", "jsonUsageReportPaths");
                this.put("--usage-report-path", "jsonUsageReportPaths");
                this.put("-ict", "includeCoverageTags");
                this.put("--include-coverage-tags", "includeCoverageTags");
                this.put("-ect", "excludeCoverageTags");
                this.put("--exclude-coverage-tags", "excludeCoverageTags");
                this.put("-f", "formats");
                this.put("-formats", "formats");
            }
        };
        int size = args.size();
        for (int i = 0; i < size; ++i) {
            String arg = "";
            String value = "";
            String field = "";
            if (args.get(i).equals("-r")) {
                arg = args.remove(i).trim();
                value = args.remove(i).trim();
                this.isOverviewReport = value.contains("o");
                this.isOverviewChartsReport = value.contains("O");
                this.isUsageReport = value.contains("u");
                this.isDetailedReport = value.contains("d");
                this.isDetailedAggregatedReport = value.contains("a");
                this.isCoverageReport = value.contains("c");
                this.breakdownReport = value.contains("B");
                this.featureMapReport = value.contains("F");
                this.featureOverviewChart = value.contains("f");
                this.knownErrorsReport = value.contains("K");
                this.systemInfoReport = value.contains("s");
                this.consolidatedReport = value.contains("C");
            } else if (args.get(i).equals("-pdf")) {
                this.toPDF = true;
                args.remove(i);
            } else if (singleValueMap.containsKey(args.get(i))) {
                arg = args.remove(i).trim();
                value = args.remove(i).trim();
                field = (String)singleValueMap.get(arg);
                this.getClass().getField(field).set(this, value);
            } else if (multiValueMap.containsKey(args.get(i))) {
                arg = args.remove(i).trim();
                value = args.remove(i).trim();
                field = (String)singleValueMap.get(arg);
                Object[] currentValues = (String[])this.getClass().getField(field).get(this);
                currentValues = (String[])ArrayUtils.add((Object[])currentValues, (Object)value.split(","));
                this.getClass().getField(field).set(this, currentValues);
            } else if (args.get(i).equals("-h") || args.get(i).equals("--help")) {
                ExtendedRuntimeOptions.loadUsageTextIfNeeded();
                System.out.println(usageText);
            }
            size = args.size();
        }
        this.processParameters();
    }

    public ExtendedRuntimeOptions(ExtendedCucumberOptions options) throws Exception {
        if (options != null) {
            this.isOverviewReport = options.overviewReport();
            this.isOverviewChartsReport = options.overviewChartsReport();
            this.isUsageReport = options.usageReport();
            this.isDetailedReport = options.detailedReport();
            this.isDetailedAggregatedReport = options.detailedAggregatedReport();
            this.isCoverageReport = options.coverageReport();
            this.jsonReportPaths = this.joinPaths(options.jsonReport(), options.jsonReports());
            this.outputFolder = options.outputFolder();
            this.reportPrefix = options.reportPrefix();
            this.retryCount = options.retryCount();
            this.screenShotSize = options.screenShotSize();
            this.toPDF = options.toPDF();
            this.pdfPageSize = options.pdfPageSize();
            this.jsonUsageReportPaths = this.joinPaths(options.jsonUsageReport(), options.jsonUsageReports());
            this.screenShotLocation = options.screenShotLocation();
            this.includeCoverageTags = options.includeCoverageTags();
            this.excludeCoverageTags = options.excludeCoverageTags();
            this.breakdownReport = options.breakdownReport();
            this.breakdownConfig = options.breakdownConfig();
            this.featureMapReport = options.featureMapReport();
            this.featureMapConfig = options.featureMapConfig();
            this.featureOverviewChart = options.featureOverviewChart();
            this.knownErrorsReport = options.knownErrorsReport();
            this.knownErrorsConfig = options.knownErrorsConfig();
            this.consolidatedReport = options.consolidatedReport();
            this.consolidatedReportConfig = options.consolidatedReportConfig();
            this.threadsCount = options.threadsCount();
            this.threadsCountValue = options.threadsCountValue();
            this.systemInfoReport = options.systemInfoReport();
            this.benchmarkReport = options.benchmarkReport();
            this.benchmarkReportConfig = options.benchmarkReportConfig();
            this.customReport = options.customReport();
            this.customReportTemplateNames = options.customReportTemplateNames();
            this.customTemplatesPath = options.customTemplatesPath();
            this.formats = options.formats();
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            String propertyName = "cucumber.reports." + field.getName();
            if (!System.getProperties().containsKey(propertyName)) continue;
            if (field.getType().equals(Boolean.TYPE)) {
                field.setBoolean(this, System.getProperty(propertyName).equalsIgnoreCase("true"));
                continue;
            }
            if (field.getType().equals(Integer.TYPE)) {
                field.setInt(this, Integer.valueOf(System.getProperty(propertyName)));
                continue;
            }
            field.set(this, System.getProperty(propertyName));
        }
        this.processParameters();
    }

    private static void loadUsageTextIfNeeded() {
        if (usageText == null) {
            try {
                InputStreamReader reader = new InputStreamReader(ExtendedRuntimeOptions.class.getResourceAsStream(USAGE_RESOURCE), "UTF-8");
                usageText = FixJava.readReader((Reader)reader);
            }
            catch (Exception e) {
                usageText = "Could not load usage text: " + e.toString();
                e.printStackTrace();
            }
        }
    }

    public final boolean isOverviewReport() {
        return this.isOverviewReport;
    }

    public boolean isOverviewChartsReport() {
        return this.isOverviewChartsReport;
    }

    public final boolean isUsageReport() {
        return this.isUsageReport;
    }

    public final boolean isDetailedReport() {
        return this.isDetailedReport;
    }

    public final boolean isDetailedAggregatedReport() {
        return this.isDetailedAggregatedReport;
    }

    public final boolean isCoverageReport() {
        return this.isCoverageReport;
    }

    public final String[] getJsonReportPaths() {
        return this.jsonReportPaths;
    }

    public final void setJsonReportPaths(String[] newPaths) {
        this.jsonReportPaths = newPaths;
    }

    public final String getOutputFolder() {
        return this.outputFolder;
    }

    public final String getReportPrefix() {
        return this.reportPrefix;
    }

    public final int getRetryCount() {
        return this.retryCount;
    }

    public final String getScreenShotSize() {
        return this.screenShotSize;
    }

    public final boolean isToPDF() {
        return this.toPDF;
    }

    public String getPdfPageSize() {
        return this.pdfPageSize;
    }

    public final String[] getJsonUsageReportPaths() {
        return this.jsonUsageReportPaths;
    }

    public final void setJsonUsageReportPaths(String[] newPaths) {
        this.jsonUsageReportPaths = newPaths;
    }

    public final String getScreenShotLocation() {
        return this.screenShotLocation;
    }

    public final String[] getIncludeCoverageTags() {
        return this.includeCoverageTags;
    }

    public final void setIncludeCoverageTags(String[] includeCoverageTagsValue) {
        this.includeCoverageTags = includeCoverageTagsValue;
    }

    public final String[] getExcludeCoverageTags() {
        return this.excludeCoverageTags;
    }

    public final void setExcludeCoverageTags(String[] excludeCoverageTagsValue) {
        this.excludeCoverageTags = excludeCoverageTagsValue;
    }

    public boolean isBreakdownReport() {
        return this.breakdownReport;
    }

    public String getBreakdownConfig() {
        return this.breakdownConfig;
    }

    public boolean isFeatureMapReport() {
        return this.featureMapReport;
    }

    public String getFeatureMapConfig() {
        return this.featureMapConfig;
    }

    public boolean isFeatureOverviewChart() {
        return this.featureOverviewChart;
    }

    public boolean isKnownErrorsReport() {
        return this.knownErrorsReport;
    }

    public String getKnownErrorsConfig() {
        return this.knownErrorsConfig;
    }

    public boolean isConsolidatedReport() {
        return this.consolidatedReport;
    }

    public String getConsolidatedReportConfig() {
        return this.consolidatedReportConfig;
    }

    public int getThreadsCount() {
        return this.threadsCount;
    }

    public String getThreadsCountValue() {
        return this.threadsCountValue;
    }

    public void setOverviewReport(boolean isOverviewReportValue) {
        this.isOverviewReport = isOverviewReportValue;
    }

    public void setUsageReport(boolean isUsageReportValue) {
        this.isUsageReport = isUsageReportValue;
    }

    public void setDetailedReport(boolean isDetailedReportValue) {
        this.isDetailedReport = isDetailedReportValue;
    }

    public void setDetailedAggregatedReport(boolean isDetailedAggregatedReportValue) {
        this.isDetailedAggregatedReport = isDetailedAggregatedReportValue;
    }

    public void setCoverageReport(boolean isCoverageReportValue) {
        this.isCoverageReport = isCoverageReportValue;
    }

    public void setOutputFolder(String outputFolderValue) {
        this.outputFolder = outputFolderValue;
    }

    public void setReportPrefix(String reportPrefixValue) {
        this.reportPrefix = reportPrefixValue;
    }

    public void setRetryCount(int retryCountValue) {
        this.retryCount = retryCountValue;
    }

    public void setScreenShotSize(String screenShotSizeValue) {
        this.screenShotSize = screenShotSizeValue;
    }

    public void setToPDF(boolean toPDFValue) {
        this.toPDF = toPDFValue;
    }

    public void setPdfPageSize(String pdfPageSizeValue) {
        this.pdfPageSize = pdfPageSizeValue;
    }

    public void setScreenShotLocation(String screenShotLocationValue) {
        this.screenShotLocation = screenShotLocationValue;
    }

    public void setBreakdownReport(boolean breakdownReportValue) {
        this.breakdownReport = breakdownReportValue;
    }

    public void setBreakdownConfig(String breakdownConfigValue) {
        this.breakdownConfig = breakdownConfigValue;
    }

    public void setFeatureMapReport(boolean featureMapReportValue) {
        this.featureMapReport = featureMapReportValue;
    }

    public void setFeatureMapConfig(String featureMapConfigValue) {
        this.featureMapConfig = featureMapConfigValue;
    }

    public void setFeatureOverviewChart(boolean featureOverviewChartValue) {
        this.featureOverviewChart = featureOverviewChartValue;
    }

    public void setKnownErrorsReport(boolean knownErrorsReportValue) {
        this.knownErrorsReport = knownErrorsReportValue;
    }

    public void setKnownErrorsConfig(String knownErrorsConfigValue) {
        this.knownErrorsConfig = knownErrorsConfigValue;
    }

    public void setConsolidatedReport(boolean consolidatedReportValue) {
        this.consolidatedReport = consolidatedReportValue;
    }

    public void setConsolidatedReportConfig(String consolidatedReportConfigValue) {
        this.consolidatedReportConfig = consolidatedReportConfigValue;
    }

    public void setOverviewChartsReport(boolean isOverviewChartsReportValue) {
        this.isOverviewChartsReport = isOverviewChartsReportValue;
    }

    public boolean isSystemInfoReport() {
        return this.systemInfoReport;
    }

    public void setSystemInfoReport(boolean systemInfoReportValue) {
        this.systemInfoReport = systemInfoReportValue;
    }

    public boolean isBenchmarkReport() {
        return this.benchmarkReport;
    }

    public void setBenchmarkReport(boolean benchmarkReportValue) {
        this.benchmarkReport = benchmarkReportValue;
    }

    public String getBenchmarkReportConfig() {
        return this.benchmarkReportConfig;
    }

    public void setBenchmarkReportConfig(String benchmarkReportConfigValue) {
        this.benchmarkReportConfig = benchmarkReportConfigValue;
    }

    public String getCustomTemplatesPath() {
        return this.customTemplatesPath;
    }

    public void setCustomTemplatesPath(String customTemplatesPathValue) {
        this.customTemplatesPath = customTemplatesPathValue;
    }

    public boolean isCustomReport() {
        return this.customReport;
    }

    public void setCustomReport(boolean customReportValue) {
        this.customReport = customReportValue;
    }

    public String[] getCustomReportTemplateNames() {
        return this.customReportTemplateNames;
    }

    public void setCustomReportTemplateNames(String[] customReportTemplateNamesValue) {
        this.customReportTemplateNames = customReportTemplateNamesValue;
    }

    public String[] getFormats() {
        return this.formats;
    }

    public void setFormats(String[] formatsValue) {
        this.formats = formatsValue;
    }

    public static ExtendedRuntimeOptions[] init(Class<?> clazz) throws Exception {
        ExtendedCucumberOptions[] options = (ExtendedCucumberOptions[])clazz.getAnnotationsByType(ExtendedCucumberOptions.class);
        return ExtendedRuntimeOptions.init(options);
    }

    public static ExtendedRuntimeOptions[] init(ExtendedCucumberOptions[] options) throws Exception {
        Object[] result = new ExtendedRuntimeOptions[]{};
        for (ExtendedCucumberOptions option : options) {
            ExtendedRuntimeOptions runtimeOption = new ExtendedRuntimeOptions(option);
            result = (ExtendedRuntimeOptions[])ArrayUtils.add((Object[])result, (Object)runtimeOption);
        }
        return result;
    }

    public String toString() {
        return "ExtendedRuntimeOptions [isOverviewReport=" + this.isOverviewReport + ", isOverviewChartsReport=" + this.isOverviewChartsReport + ", isUsageReport=" + this.isUsageReport + ", isDetailedReport=" + this.isDetailedReport + ", isDetailedAggregatedReport=" + this.isDetailedAggregatedReport + ", isCoverageReport=" + this.isCoverageReport + ", jsonReportPaths=" + Arrays.toString(this.jsonReportPaths) + ", outputFolder=" + this.outputFolder + ", reportPrefix=" + this.reportPrefix + ", retryCount=" + this.retryCount + ", screenShotSize=" + this.screenShotSize + ", toPDF=" + this.toPDF + ", pdfPageSize=" + this.pdfPageSize + ", jsonUsageReportPaths=" + Arrays.toString(this.jsonUsageReportPaths) + ", screenShotLocation=" + this.screenShotLocation + ", includeCoverageTags=" + Arrays.toString(this.includeCoverageTags) + ", excludeCoverageTags=" + Arrays.toString(this.excludeCoverageTags) + ", breakdownReport=" + this.breakdownReport + ", breakdownConfig=" + this.breakdownConfig + ", featureMapReport=" + this.featureMapReport + ", featureMapConfig=" + this.featureMapConfig + ", featureOverviewChart=" + this.featureOverviewChart + ", knownErrorsReport=" + this.knownErrorsReport + ", knownErrorsConfig=" + this.knownErrorsConfig + ", consolidatedReport=" + this.consolidatedReport + ", consolidatedReportConfig=" + this.consolidatedReportConfig + ", threadsCount=" + this.threadsCount + ", threadsCountValue=" + this.threadsCountValue + "]";
    }
}

