/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.utils.helpers;

import com.cedarsoftware.util.io.JsonReader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class FreemarkerConfiguration {
    private static final String TEMPLATE_EXTENSION = ".ftlh";
    private static Configuration config;
    private static final Map<String, String> DEFAULT_RESOURCES;

    private FreemarkerConfiguration() {
    }

    private static void loadConfig(Map<String, String> resourceMap) throws Exception {
        config = new Configuration(Configuration.VERSION_2_3_26);
        Object[] loaders = new TemplateLoader[]{};
        for (Map.Entry<String, String> resource : resourceMap.entrySet()) {
            String templateString = "";
            InputStream is = FreemarkerConfiguration.class.getResourceAsStream(resource.getValue());
            templateString = is != null ? IOUtils.toString((InputStream)is) : FileUtils.readFileToString((File)new File(resource.getValue()), (String)"UTF-8");
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            stringLoader.putTemplate(resource.getKey(), templateString);
            loaders = (TemplateLoader[])ArrayUtils.add((Object[])loaders, (Object)stringLoader);
        }
        MultiTemplateLoader multiLoader = new MultiTemplateLoader((TemplateLoader[])loaders);
        config.setTemplateLoader((TemplateLoader)multiLoader);
        config.setDefaultEncoding("UTF-8");
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setLogTemplateExceptions(false);
        config.setAPIBuiltinEnabled(true);
        config.setURLEscapingCharset("UTF-8");
        config.setLocale(Locale.US);
        BeansWrapperBuilder builder = new BeansWrapperBuilder(Configuration.VERSION_2_3_26);
        TemplateHashModel staticModels = builder.build().getStaticModels();
        config.setSharedVariable("statics", (TemplateModel)staticModels);
    }

    private static Map<String, String> loadTemplatesFromResource(String configFile) throws IOException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.putAll(DEFAULT_RESOURCES);
        HashMap loadedMap = (HashMap)JsonReader.jsonToJava((String)configFile);
        for (Map.Entry entry : loadedMap.entrySet()) {
            URL tmplFileUrl = FreemarkerConfiguration.class.getResource((String)entry.getValue());
            File tmplFile = new File((String)entry.getValue());
            if (tmplFileUrl == null && !tmplFile.exists()) continue;
            resultMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return resultMap;
    }

    private static Map<String, String> loadTemplatesFromFile(File configFile) throws IOException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.putAll(DEFAULT_RESOURCES);
        String content = FileUtils.readFileToString((File)configFile, (String)"UTF-8");
        HashMap loadedMap = (HashMap)JsonReader.jsonToJava((String)content);
        for (Map.Entry entry : loadedMap.entrySet()) {
            File tmplFile = new File((String)entry.getValue());
            if (!tmplFile.exists() && FreemarkerConfiguration.class.getResource((String)entry.getValue()) == null) continue;
            resultMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return resultMap;
    }

    private static File[] getTemplateFilesFromDirectory(File folder) {
        File[] files;
        Object[] subFiles = new File[]{};
        Object[] resultFiles = new File[]{};
        for (File file : files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(FreemarkerConfiguration.TEMPLATE_EXTENSION);
            }
        })) {
            if (file.isDirectory()) {
                subFiles = (File[])ArrayUtils.addAll((Object[])subFiles, (Object[])FreemarkerConfiguration.getTemplateFilesFromDirectory(file));
                continue;
            }
            resultFiles = (File[])ArrayUtils.add((Object[])resultFiles, (Object)file);
        }
        return (File[])ArrayUtils.addAll((Object[])resultFiles, (Object[])subFiles);
    }

    private static Map<String, String> loadTemplatesFromFolder(File configFolder) {
        File[] files;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.putAll(DEFAULT_RESOURCES);
        for (File file : files = FreemarkerConfiguration.getTemplateFilesFromDirectory(configFolder)) {
            String baseFolder = configFolder.getAbsolutePath();
            String fileEntry = file.getAbsolutePath().substring(baseFolder.length() + 1, file.getAbsolutePath().length() - TEMPLATE_EXTENSION.length());
            resultMap.put(fileEntry, file.getAbsolutePath());
        }
        return resultMap;
    }

    public static Map<String, String> getResourceMap(String location) throws Exception {
        Map<String, String> resultMap = new HashMap<String, String>();
        resultMap.putAll(DEFAULT_RESOURCES);
        if (StringUtils.isBlank((CharSequence)location)) {
            return resultMap;
        }
        URL locationUrl = FreemarkerConfiguration.class.getResource(location);
        if (locationUrl != null) {
            InputStream is = FreemarkerConfiguration.class.getResourceAsStream(location);
            String locationAsString = IOUtils.toString((InputStream)is);
            if (locationAsString.trim().startsWith("{")) {
                resultMap = FreemarkerConfiguration.loadTemplatesFromResource(locationAsString);
            }
            return resultMap;
        }
        File resLocation = new File(location);
        if (!resLocation.exists()) {
            return resultMap;
        }
        resultMap = resLocation.isFile() ? FreemarkerConfiguration.loadTemplatesFromFile(resLocation) : FreemarkerConfiguration.loadTemplatesFromFolder(resLocation);
        return resultMap;
    }

    public static Configuration get(String location) throws Exception {
        if (config == null) {
            Map<String, String> resourceMap = FreemarkerConfiguration.getResourceMap(location);
            FreemarkerConfiguration.loadConfig(resourceMap);
        }
        return config;
    }

    public static void flush() {
        config = null;
    }

    static {
        DEFAULT_RESOURCES = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("pie_chart", "/templates/default/pie_chart.ftlh");
                this.put("tables", "/templates/default/tables.ftlh");
                this.put("benchmark", "/templates/default/benchmark.ftlh");
                this.put("consolidated", "/templates/default/consolidated.ftlh");
                this.put("overview", "/templates/default/overview.ftlh");
                this.put("coverage", "/templates/default/coverage.ftlh");
                this.put("known_errors", "/templates/default/known_errors.ftlh");
                this.put("system_info", "/templates/default/system_info.ftlh");
                this.put("feature_overview", "/templates/default/feature_overview.ftlh");
                this.put("overview_chart", "/templates/default/overview_chart.ftlh");
                this.put("detailed", "/templates/default/detailed.ftlh");
                this.put("retrospective", "/templates/default/retrospective.ftlh");
                this.put("breakdown", "/templates/default/breakdown.ftlh");
                this.put("feature_map", "/templates/default/feature_map.ftlh");
                this.put("usage", "/templates/default/usage.ftlh");
                this.put("split_feature", "/templates/default/split_feature.ftlh");
            }
        };
    }
}

