/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.result;

import com.cedarsoftware.util.io.JsonObject;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberBeforeAfterResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberStepResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberTagResults;
import com.github.mkolisnyk.cucumber.reporting.utils.helpers.JsonUtils;
import org.apache.commons.lang.ArrayUtils;

public class CucumberScenarioResult {
    private CucumberFeatureResult feature;
    private String id;
    private CucumberTagResults[] tags;
    private String description;
    private String name;
    private String keyword;
    private Long line;
    private CucumberStepResult[] steps = new CucumberStepResult[0];
    private String type;
    private CucumberBeforeAfterResult before;
    private CucumberBeforeAfterResult after;
    private int passed = 0;
    private int failed = 0;
    private int skipped = 0;
    private int undefined = 0;
    private int known = 0;
    private double duration = 0.0;
    private int rerunAttempts = 0;
    private String[] includeCoverageTags = new String[0];
    private String[] excludeCoverageTags = new String[0];

    public CucumberScenarioResult() {
    }

    public CucumberScenarioResult(JsonObject<String, Object> json) {
        int i;
        Object[] objs;
        this.id = (String)json.get((Object)"id");
        this.description = (String)json.get((Object)"description");
        this.name = (String)json.get((Object)"name");
        this.keyword = (String)json.get((Object)"keyword");
        this.line = (Long)json.get((Object)"line");
        this.type = (String)json.get((Object)"type");
        if (json.containsKey((Object)"before")) {
            objs = (Object[])json.get((Object)"before");
            for (i = 0; i < objs.length; ++i) {
                this.before = new CucumberBeforeAfterResult((JsonObject<String, Object>)((JsonObject)objs[i]));
            }
        }
        if (json.containsKey((Object)"after")) {
            objs = (Object[])json.get((Object)"after");
            for (i = 0; i < objs.length; ++i) {
                this.after = new CucumberBeforeAfterResult((JsonObject<String, Object>)((JsonObject)objs[i]));
            }
        }
        if (json.containsKey((Object)"steps")) {
            objs = (Object[])json.get((Object)"steps");
            this.steps = new CucumberStepResult[objs.length];
            for (i = 0; i < objs.length; ++i) {
                this.steps[i] = new CucumberStepResult((JsonObject<String, Object>)((JsonObject)objs[i]));
            }
        }
        objs = new Object[]{};
        objs = (Object[])json.getOrDefault((Object)"tags", (Object)new Object[0]);
        this.tags = new CucumberTagResults[objs.length];
        for (i = 0; i < objs.length; ++i) {
            this.tags[i] = new CucumberTagResults((JsonObject<String, Object>)((JsonObject)objs[i]));
        }
        this.tags = JsonUtils.toTagArray(json);
    }

    public void updateFailedToKnown() {
        for (CucumberStepResult step : this.steps) {
            String status = step.getResult().getStatus();
            if (!status.equalsIgnoreCase("failed")) continue;
            step.getResult().setStatus("known");
        }
    }

    private void valuateStepStatus(String status) {
        if (status.equalsIgnoreCase("passed")) {
            ++this.passed;
        } else if (status.equalsIgnoreCase("known")) {
            ++this.known;
        } else if (status.equalsIgnoreCase("failed")) {
            ++this.failed;
        } else if (status.equalsIgnoreCase("skipped")) {
            ++this.skipped;
        } else {
            ++this.undefined;
        }
    }

    public void valuate() {
        int nanosecondsInMillisecond = 1000000;
        float millesecondsInSecond = 1000.0f;
        this.passed = 0;
        this.failed = 0;
        this.skipped = 0;
        this.undefined = 0;
        this.known = 0;
        this.duration = 0.0;
        if (this.steps == null) {
            return;
        }
        for (CucumberStepResult step : this.steps) {
            String status = "undefined";
            if (step.getResult() != null) {
                status = step.getResult().getStatus();
            }
            this.valuateStepStatus(status);
            this.duration += (double)((float)(step.getResult().getDuration() / 1000000L) / 1000.0f);
        }
        if (!this.isInTagSet(this.includeCoverageTags, this.excludeCoverageTags)) {
            ++this.undefined;
        }
        if (this.getBefore() != null) {
            this.duration += (double)((float)(this.getBefore().getResult().getDuration() / 1000000L) / 1000.0f);
        }
        if (this.getAfter() != null) {
            this.duration += (double)((float)(this.getAfter().getResult().getDuration() / 1000000L) / 1000.0f);
        }
    }

    public final int getPassed() {
        return this.passed;
    }

    public final int getFailed() {
        return this.failed;
    }

    public final int getUndefined() {
        return this.undefined;
    }

    public final int getSkipped() {
        return this.skipped;
    }

    public int getKnown() {
        return this.known;
    }

    public String getStatus(boolean valuate) {
        String[] statuses;
        if (valuate) {
            this.valuate();
        }
        for (String status : statuses = new String[]{"failed", "known", "undefined", "skipped", "passed"}) {
            int value = 0;
            try {
                value = this.getClass().getDeclaredField(status).getInt(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (value <= 0) continue;
            return status;
        }
        return "undefined";
    }

    public String getStatus() {
        return this.getStatus(true);
    }

    public final String getId() {
        return this.id;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getName() {
        return this.name;
    }

    public final String getKeyword() {
        return this.keyword;
    }

    public final Long getLine() {
        return this.line;
    }

    public final CucumberStepResult[] getSteps() {
        return this.steps;
    }

    public void setSteps(CucumberStepResult[] stepsValue) {
        this.steps = stepsValue;
    }

    public final String getType() {
        return this.type;
    }

    public final void setId(String idValue) {
        this.id = idValue;
    }

    public final void setName(String nameValue) {
        this.name = nameValue;
    }

    public final CucumberTagResults[] getTags() {
        return this.tags;
    }

    public final void setTags(CucumberTagResults[] tagsValue) {
        this.tags = tagsValue;
    }

    public final double getDuration() {
        return this.duration;
    }

    public final CucumberBeforeAfterResult getBefore() {
        return this.before;
    }

    public final CucumberBeforeAfterResult getAfter() {
        return this.after;
    }

    public final int getRerunAttempts() {
        return this.rerunAttempts;
    }

    public void addRerunAttempts(int count) {
        this.rerunAttempts += count;
    }

    public String[] getAllTags() {
        Object[] result = new String[]{};
        for (CucumberTagResults tag : this.getTags()) {
            result = (String[])ArrayUtils.add((Object[])result, (Object)tag.getName());
        }
        return result;
    }

    public boolean isInTagSet(String[] include, String[] exclude) {
        Object[] tagValues = this.getAllTags();
        for (String tag : include) {
            if (!ArrayUtils.contains((Object[])tagValues, (Object)tag)) continue;
            return true;
        }
        for (String tag : exclude) {
            if (!ArrayUtils.contains((Object[])tagValues, (Object)tag)) continue;
            return false;
        }
        return true;
    }

    public final String[] getIncludeCoverageTags() {
        return this.includeCoverageTags;
    }

    public final void setIncludeCoverageTags(String[] includeCoverageTagsValue) {
        this.includeCoverageTags = includeCoverageTagsValue;
    }

    public final String[] getExcludeCoverageTags() {
        return this.excludeCoverageTags;
    }

    public final void setExcludeCoverageTags(String[] excludeCoverageTagsValue) {
        this.excludeCoverageTags = excludeCoverageTagsValue;
    }

    public CucumberFeatureResult getFeature() {
        return this.feature;
    }

    public void setFeature(CucumberFeatureResult featureValue) {
        this.feature = featureValue;
    }

    public boolean isSameAs(CucumberScenarioResult another) {
        return another != null && this.getId().equals(another.getId());
    }

    public void setPassed(int passedValue) {
        this.passed = passedValue;
    }

    public void setFailed(int failedValue) {
        this.failed = failedValue;
    }

    public void setSkipped(int skippedValue) {
        this.skipped = skippedValue;
    }

    public void setUndefined(int undefinedValue) {
        this.undefined = undefinedValue;
    }

    public void setKnown(int knownValue) {
        this.known = knownValue;
    }

    public void addBackground(CucumberScenarioResult background) {
        this.steps = (CucumberStepResult[])ArrayUtils.addAll((Object[])background.getSteps(), (Object[])this.getSteps());
        this.valuate();
    }
}

