/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.interfaces;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.github.mkolisnyk.cucumber.reporting.types.beans.CommonDataBean;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportError;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.utils.helpers.FreemarkerConfiguration;
import com.github.mkolisnyk.cucumber.reporting.utils.helpers.StringConversionUtils;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXB;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.simple.Graphics2DRenderer;
import org.xhtmlrenderer.util.FSImageWriter;

public abstract class CucumberResultsCommon {
    public static final int CHART_WIDTH = 450;
    public static final int CHART_HEIGHT = 300;
    public static final int CHART_THICKNESS = 20;
    private String[] sourceFiles;
    private String outputDirectory;
    private String outputName;
    private String pdfPageSize = "auto";
    private String templatesLocation = "";

    public abstract CucumberReportTypes getReportType();

    public abstract CucumberReportLink getReportDocLink();

    public abstract void validateParameters();

    public CucumberResultsCommon() {
    }

    public CucumberResultsCommon(ExtendedRuntimeOptions extendedOptions) {
        this.setOutputDirectory(extendedOptions.getOutputFolder());
        this.setOutputName(extendedOptions.getReportPrefix());
        this.setSourceFiles(extendedOptions.getJsonReportPaths());
        this.setPdfPageSize(extendedOptions.getPdfPageSize());
        this.setTemplatesLocation(extendedOptions.getCustomTemplatesPath());
    }

    public String constructErrorMessage(CucumberReportError error, String suffix) {
        return String.format("%s: %s. For more information, please, refer to: %s%s", new Object[]{this.getReportType(), error, this.getReportDocLink(), suffix});
    }

    public String reportSuffix() {
        return this.getReportType().suffix();
    }

    public String templateName() {
        return this.getReportType().template();
    }

    public File getOutputHtmlFile() {
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + this.reportSuffix() + ".html");
        return outFile;
    }

    public final String getOutputDirectory() {
        return this.outputDirectory;
    }

    public final void setOutputDirectory(String outputDirectoryValue) {
        this.outputDirectory = StringConversionUtils.transformPathString(outputDirectoryValue);
    }

    public final String getOutputName() {
        return this.outputName;
    }

    public final void setOutputName(String outputNameValue) {
        this.outputName = StringConversionUtils.transformPathString(outputNameValue);
    }

    public final String getSourceFile() {
        return this.sourceFiles[0];
    }

    public final void setSourceFile(String sourceFileValue) {
        this.sourceFiles = sourceFileValue == null ? null : new String[]{sourceFileValue};
    }

    public String[] getSourceFiles() {
        return this.sourceFiles;
    }

    public void setSourceFiles(String[] sourceFilesValue) {
        this.sourceFiles = sourceFilesValue;
    }

    public String getPdfPageSize() {
        return this.pdfPageSize;
    }

    public void setPdfPageSize(String pdfPageSizeValue) {
        this.pdfPageSize = pdfPageSizeValue;
    }

    public boolean isImageExportable() {
        return false;
    }

    public String getTemplatesLocation() {
        return this.templatesLocation;
    }

    public void setTemplatesLocation(String templatesLocationValue) {
        this.templatesLocation = templatesLocationValue;
    }

    public CucumberFeatureResult[] readFileContent(String sourceFileValue) throws Exception {
        FileInputStream fis = null;
        JsonReader jr = null;
        File file = new File(sourceFileValue);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException();
        }
        fis = new FileInputStream(file);
        jr = new JsonReader((InputStream)fis, true);
        Object[] objs = (Object[])jr.readObject();
        CucumberFeatureResult[] sources = new CucumberFeatureResult[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            sources[i] = new CucumberFeatureResult((JsonObject<String, Object>)((JsonObject)objs[i]));
            sources[i].mergeBeckgroundsToScenatios();
        }
        jr.close();
        fis.close();
        return sources;
    }

    public void dumpOverviewStats(File outFile, CucumberFeatureResult[] results) throws IOException {
        int[][] stats = this.getStatuses(results);
        JAXB.marshal((Object)stats, (File)outFile);
        String content = FileUtils.readFileToString((File)outFile);
        content = content.replaceAll("\\[]\\[]", "");
        FileUtils.writeStringToFile((File)outFile, (String)content);
    }

    private void convertSvgToPng(File svg, File png) throws Exception {
        String svgUriInput = svg.toURI().toURL().toString();
        TranscoderInput inputSvgImage = new TranscoderInput(svgUriInput);
        FileOutputStream pngOStream = new FileOutputStream(png);
        TranscoderOutput outputPngImage = new TranscoderOutput((OutputStream)pngOStream);
        PNGTranscoder myConverter = new PNGTranscoder();
        myConverter.transcode(inputSvgImage, outputPngImage);
        pngOStream.flush();
        ((OutputStream)pngOStream).close();
    }

    public String replaceSvgWithPng(File htmlFile) throws Exception {
        String tempPath = this.getOutputDirectory() + File.separator + "temp" + new Date().getTime();
        File folder = new File(tempPath);
        folder.mkdirs();
        folder.deleteOnExit();
        String htmlText = FileUtils.readFileToString((File)htmlFile);
        Pattern p = Pattern.compile("<svg(.*?)</svg>", 42);
        Matcher m = p.matcher(htmlText);
        int index = 0;
        while (m.find()) {
            String svg = m.group(0);
            File svgOutput = new File(tempPath + File.separator + index + ".svg");
            svgOutput.deleteOnExit();
            FileUtils.writeStringToFile((File)svgOutput, (String)svg);
            File png = new File(tempPath + File.separator + index + ".png");
            png.deleteOnExit();
            this.convertSvgToPng(svgOutput, png);
            htmlText = m.replaceFirst(Matcher.quoteReplacement(String.format(Locale.US, "<img src=\"%s\"></img>", folder.getName() + "/" + index + ".png")));
            m = p.matcher(htmlText);
            ++index;
        }
        return htmlText;
    }

    protected <T extends CommonDataBean> void generateReportFromTemplate(File outFile, String templateName, T bean) throws Exception {
        Configuration cfg = FreemarkerConfiguration.get(this.getTemplatesLocation());
        Template temp = cfg.getTemplate(templateName);
        outFile.getAbsoluteFile().getParentFile().mkdirs();
        FileWriter writer = new FileWriter(outFile);
        bean.setPdfPageSize(this.getPdfPageSize());
        if (StringUtils.isBlank((CharSequence)bean.getTitle())) {
            bean.setTitle(this.getReportType().toString());
        }
        BeansWrapper wrapper = new BeansWrapper(Configuration.VERSION_2_3_23);
        wrapper.wrap(bean);
        temp.process(bean, (Writer)writer);
        writer.close();
    }

    private File generateBackupFile(File htmlFile) throws Exception {
        File backupFile = new File(htmlFile.getAbsolutePath() + ".bak.html");
        String updatedContent = this.replaceSvgWithPng(htmlFile);
        updatedContent = updatedContent.replaceAll("\"hoverTable\"", "\"_hoverTable\"");
        updatedContent = updatedContent.replaceAll("__PAGESIZE__", this.getPdfPageSize());
        FileUtils.writeStringToFile((File)backupFile, (String)updatedContent);
        return backupFile;
    }

    private void exportToPDF(File htmlFile, String suffix) throws Exception {
        File bakupFile = this.generateBackupFile(htmlFile);
        String url = bakupFile.toURI().toURL().toString();
        String outputFile = this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + suffix + ".pdf";
        FileOutputStream os = new FileOutputStream(outputFile);
        ITextRenderer renderer = new ITextRenderer();
        renderer.setDocument(url);
        renderer.layout();
        renderer.createPDF((OutputStream)os);
        ((OutputStream)os).close();
    }

    private void exportToImage(File htmlFile, String suffix, String format) throws Exception {
        int defaultWidth = 1024;
        File bakupFile = this.generateBackupFile(htmlFile);
        String outputFile = this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + suffix + "." + format;
        BufferedImage buff = null;
        buff = Graphics2DRenderer.renderToImageAutoSize((String)bakupFile.toURI().toURL().toString(), (int)1024);
        FSImageWriter imageWriter = new FSImageWriter();
        imageWriter.write(buff, outputFile);
    }

    public void export(File htmlFile, String suffix, String[] formats, boolean isImageExportable) throws Exception {
        for (String format : formats) {
            if (format.trim().equalsIgnoreCase("pdf")) {
                this.exportToPDF(htmlFile, suffix);
                continue;
            }
            if (!isImageExportable) continue;
            this.exportToImage(htmlFile, suffix, format);
        }
    }

    public int[][] getStatuses(CucumberFeatureResult[] results) {
        return null;
    }
}

