/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.interfaces.KECompatibleReport;
import com.github.mkolisnyk.cucumber.reporting.types.beans.KnownErrorsDataBean;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportError;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsModel;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsResultSet;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;

public class CucumberKnownErrorsReport
extends KECompatibleReport {
    public CucumberKnownErrorsReport() {
    }

    public CucumberKnownErrorsReport(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.KNOWN_ERRORS;
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.KNOWN_ERRORS_URL;
    }

    @Override
    public void execute(KnownErrorsModel batch, String[] formats) throws Exception {
        this.validateParameters();
        CucumberFeatureResult[] features = this.readFileContent(true);
        this.execute(batch, features, formats);
    }

    public void execute(KnownErrorsModel batch, CucumberFeatureResult[] features, String[] formats) throws Exception {
        this.validateParameters();
        File outFile = this.getOutputHtmlFile();
        KnownErrorsDataBean data = new KnownErrorsDataBean();
        Object[] scenarios = new CucumberScenarioResult[]{};
        for (CucumberFeatureResult feature : features) {
            scenarios = (CucumberScenarioResult[])ArrayUtils.addAll((Object[])scenarios, (Object[])feature.getElements());
        }
        KnownErrorsResultSet results = new KnownErrorsResultSet();
        results.valuate((CucumberScenarioResult[])scenarios, batch);
        data.setResults(results.getResults());
        this.generateReportFromTemplate(outFile, this.templateName(), data);
        this.export(outFile, this.reportSuffix(), formats, this.isImageExportable());
    }

    @Override
    @Deprecated
    public void execute(boolean aggregate, String[] formats) throws Exception {
    }

    @Override
    public void validateParameters() {
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_DIRECTORY, ""), (Object)this.getOutputDirectory());
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_NAME, ""), (Object)this.getOutputName());
    }

    @Override
    public void execute(KnownErrorsModel batch, boolean aggregate, String[] formats) throws Exception {
        this.execute(batch, formats);
    }

    @Override
    @Deprecated
    public void execute(boolean aggregate, CucumberFeatureResult[] results, String[] formats) throws Exception {
    }

    @Override
    public void execute(KnownErrorsModel model, CucumberFeatureResult[] results, boolean aggregate, String[] formats) throws Exception {
        this.execute(model, results, formats);
    }
}

