/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.interfaces.KECompatibleReport;
import com.github.mkolisnyk.cucumber.reporting.types.OverviewStats;
import com.github.mkolisnyk.cucumber.reporting.types.beans.DetailedReportingDataBean;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsModel;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberEmbedding;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberStepResult;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class CucumberDetailedResults
extends KECompatibleReport {
    private String screenShotLocation;
    private String screenShotWidth = "100%";

    public CucumberDetailedResults() {
    }

    public CucumberDetailedResults(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
        this.setScreenShotLocation(extendedOptions.getScreenShotLocation());
        this.setScreenShotWidth(extendedOptions.getScreenShotSize());
    }

    public final String getScreenShotLocation() {
        return this.screenShotLocation;
    }

    public final void setScreenShotLocation(String screenShotLocationValue) {
        this.screenShotLocation = screenShotLocationValue;
    }

    public final String getScreenShotWidth() {
        return this.screenShotWidth;
    }

    public final void setScreenShotWidth(String screenShotWidthValue) {
        this.screenShotWidth = screenShotWidthValue;
    }

    public String generateNameFromId(String scId) {
        if (scId == null) {
            scId = "null";
        }
        String result = scId.replaceAll("[^A-Za-z0-9]", "_");
        return result;
    }

    private String getExtensionFromMime(String mime) {
        if (mime.contains("png")) {
            return "png";
        }
        if (mime.contains("jpg") || mime.contains("jpeg")) {
            return "jpg";
        }
        return "txt";
    }

    private String[] generateEmbededScreenShots(CucumberScenarioResult scenario, CucumberStepResult step) throws IOException {
        Object[] outputs = new String[]{};
        String scenarioId = scenario.getId();
        if (StringUtils.isBlank((String)scenarioId)) {
            scenarioId = "background";
        }
        if (step.getEmbeddings() != null) {
            int index = 0;
            long base = new Date().getTime();
            for (CucumberEmbedding embedding : step.getEmbeddings()) {
                String embedPath = Paths.get(this.getScreenShotLocation(), this.generateNameFromId(scenarioId) + (base + (long)index) + "." + this.getExtensionFromMime(embedding.getMimeType())).toString().replace("\\", "/");
                File embedShot = new File(this.getOutputDirectory() + embedPath);
                FileUtils.writeByteArrayToFile((File)embedShot, (byte[])embedding.getData());
                outputs = (String[])ArrayUtils.add((Object[])outputs, (Object)embedPath);
                ++index;
            }
        }
        return outputs;
    }

    @Override
    public int[][] getStatuses(CucumberFeatureResult[] results) {
        return null;
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.DETAILED_REPORT;
    }

    @Override
    public void validateParameters() {
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.DETAILED_URL;
    }

    @Override
    public void execute(boolean aggregate, String[] formats) throws Exception {
        this.execute((KnownErrorsModel)null, aggregate, formats);
    }

    @Override
    public void execute(KnownErrorsModel batch, CucumberFeatureResult[] features, boolean aggregate, String[] formats) throws Exception {
        String formatName = "";
        for (CucumberFeatureResult feature : features) {
            feature.valuate();
            if (batch == null) continue;
            feature.valuateKnownErrors(batch);
        }
        formatName = aggregate ? "%s%s%s-agg-" + this.reportSuffix() + ".html" : "%s%s%s-" + this.reportSuffix() + ".html";
        File outFile = new File(String.format(Locale.US, formatName, this.getOutputDirectory(), File.separator, this.getOutputName()));
        DetailedReportingDataBean data = new DetailedReportingDataBean();
        OverviewStats stats = new OverviewStats();
        data.setStats(stats.valuate(features));
        data.setResults(features);
        for (CucumberFeatureResult feature : features) {
            for (CucumberScenarioResult scenario : feature.getElements()) {
                for (CucumberStepResult step : scenario.getSteps()) {
                    String[] screenShotLocations = this.generateEmbededScreenShots(scenario, step);
                    step.setScreenShotLocations(screenShotLocations);
                }
            }
        }
        data.setScreenShotWidth(this.getScreenShotWidth());
        this.generateReportFromTemplate(outFile, this.templateName(), data);
        this.export(outFile, this.reportSuffix(), formats, this.isImageExportable());
    }

    @Override
    public void execute(KnownErrorsModel batch, boolean aggregate, String[] formats) throws Exception {
        CucumberFeatureResult[] features = this.readFileContent(aggregate);
        this.execute(batch, features, aggregate, formats);
    }

    @Override
    public void execute(boolean aggregate, CucumberFeatureResult[] features, String[] formats) throws Exception {
        this.execute((KnownErrorsModel)null, features, aggregate, formats);
    }
}

