/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.interfaces.ConfigurableReport;
import com.github.mkolisnyk.cucumber.reporting.types.beans.BenchmarkDataBean;
import com.github.mkolisnyk.cucumber.reporting.types.benchmark.BenchmarkReportInfo;
import com.github.mkolisnyk.cucumber.reporting.types.benchmark.BenchmarkReportModel;
import com.github.mkolisnyk.cucumber.reporting.types.benchmark.BenchmarkRowData;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportError;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;

public class CucumberBenchmarkReport
extends ConfigurableReport<BenchmarkReportModel> {
    private BenchmarkDataBean data;

    public CucumberBenchmarkReport(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
    }

    public CucumberBenchmarkReport() {
    }

    @Override
    public void execute(BenchmarkReportModel batch, boolean aggregate, String[] formats) throws Exception {
        Object[] titles = new String[]{};
        CucumberFeatureResult[][] results = new CucumberFeatureResult[][]{};
        Object[] uniqueFeatureIds = new String[]{};
        Object[] uniqueScenarioIds = new String[]{};
        this.data = new BenchmarkDataBean();
        for (BenchmarkReportInfo item : batch.getItems()) {
            CucumberFeatureResult[] cucumberFeatureResultArray = this.readFileContent(item.getPath(), aggregate);
            titles = (String[])ArrayUtils.add((Object[])titles, (Object)item.getTitle());
            results = (CucumberFeatureResult[][])ArrayUtils.add((Object[])results, (Object)cucumberFeatureResultArray);
            for (CucumberFeatureResult feature : cucumberFeatureResultArray) {
                String id = feature.getId();
                if (!ArrayUtils.contains((Object[])uniqueFeatureIds, (Object)id)) {
                    uniqueFeatureIds = (String[])ArrayUtils.add((Object[])uniqueFeatureIds, (Object)id);
                }
                for (CucumberScenarioResult scenario : feature.getElements()) {
                    id = scenario.getId();
                    if (ArrayUtils.contains((Object[])uniqueScenarioIds, (Object)id)) continue;
                    uniqueScenarioIds = (String[])ArrayUtils.add((Object[])uniqueScenarioIds, (Object)id);
                }
            }
        }
        this.data.setHeaders((String[])titles);
        for (Object id : uniqueFeatureIds) {
            BenchmarkRowData benchmarkRowData = new BenchmarkRowData();
            benchmarkRowData.addFeatureResults((String)id, results);
            this.data.setFeatureRows((BenchmarkRowData[])ArrayUtils.add((Object[])this.data.getFeatureRows(), (Object)benchmarkRowData));
        }
        CucumberScenarioResult[][] scenarioData = BenchmarkRowData.toScenarioList(results);
        for (String string : uniqueScenarioIds) {
            BenchmarkRowData row = new BenchmarkRowData();
            row.addScenarioResults(string, scenarioData);
            this.data.setScenarioRows((BenchmarkRowData[])ArrayUtils.add((Object[])this.data.getScenarioRows(), (Object)row));
        }
        File outFile = this.getOutputHtmlFile();
        this.generateReportFromTemplate(outFile, this.templateName(), this.data);
        this.export(outFile, this.reportSuffix(), formats, this.isImageExportable());
    }

    @Override
    public void execute(File config, boolean aggregate, String[] formats) throws Exception {
        this.execute(config, true, formats);
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.BENCHMARK_REPORT;
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.BENCHMARK_URL;
    }

    @Override
    public void validateParameters() {
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_DIRECTORY, ""), (Object)this.getOutputDirectory());
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_NAME, ""), (Object)this.getOutputName());
    }

    @Override
    public void execute(boolean aggregate, CucumberFeatureResult[] results, String[] formats) throws Exception {
    }

    @Override
    public void execute(BenchmarkReportModel model, CucumberFeatureResult[] results, boolean aggregate, String[] formats) throws Exception {
    }
}

