/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.tomcat;

import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.servers.AbstractConfigurationBuilder;
import com.github.mjeanroy.junit.servers.tomcat.AbstractEmbeddedTomcatConfiguration;

abstract class AbstractEmbeddedTomcatConfigurationBuilder<SELF extends AbstractConfigurationBuilder<SELF, CONFIG>, CONFIG extends AbstractEmbeddedTomcatConfiguration>
extends AbstractConfigurationBuilder<SELF, CONFIG> {
    private String baseDir = "./tomcat-work";
    private boolean keepBaseDir = false;
    private boolean enableNaming = true;
    private boolean forceMetaInf = true;

    AbstractEmbeddedTomcatConfigurationBuilder() {
        this.withClasspath("./target/classes");
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public boolean isKeepBaseDir() {
        return this.keepBaseDir;
    }

    public boolean isEnableNaming() {
        return this.enableNaming;
    }

    public boolean isForceMetaInf() {
        return this.forceMetaInf;
    }

    public SELF withBaseDir(String baseDir) {
        this.baseDir = Preconditions.notNull(baseDir, "baseDir");
        return this.self();
    }

    public SELF keepBaseDir() {
        this.keepBaseDir = true;
        return this.self();
    }

    public SELF deleteBaseDir() {
        this.keepBaseDir = false;
        return this.self();
    }

    public SELF enableNaming() {
        return this.toggleNaming(true);
    }

    public SELF disableNaming() {
        return this.toggleNaming(false);
    }

    public SELF enableForceMetaInf() {
        return this.toggleMetaInf(true);
    }

    public SELF disableForceMetaInf() {
        return this.toggleMetaInf(false);
    }

    private SELF toggleNaming(boolean enableNaming) {
        this.enableNaming = enableNaming;
        return this.self();
    }

    private SELF toggleMetaInf(boolean forceMetaInf) {
        this.forceMetaInf = forceMetaInf;
        return this.self();
    }
}

