/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.junit4;

import com.github.mjeanroy.junit.servers.engine.Servers;
import com.github.mjeanroy.junit.servers.junit4.AnnotationsHandlerRule;
import com.github.mjeanroy.junit.servers.junit4.ServerRule;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class JunitServerRunner
extends BlockJUnit4ClassRunner {
    private static final Logger log = LoggerFactory.getLogger(JunitServerRunner.class);
    private final EmbeddedServer<?> server;
    private final AbstractConfiguration configuration;

    public JunitServerRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.server = Servers.instantiate(klass);
        this.configuration = this.server.getConfiguration();
    }

    protected JunitServerRunner(Class<?> klass, EmbeddedServer<?> server) throws InitializationError {
        super(klass);
        this.server = server;
        this.configuration = server.getConfiguration();
    }

    protected List<TestRule> classRules() {
        ServerRule serverRule = new ServerRule(this.server);
        log.debug("Injecting {} to class rules", (Object)serverRule);
        List classRules = super.classRules();
        classRules.add(serverRule);
        return classRules;
    }

    protected List<TestRule> getTestRules(Object target) {
        AnnotationsHandlerRule rule = new AnnotationsHandlerRule(target, this.server, this.configuration);
        log.debug("Injecting {} to test rules", (Object)rule);
        List testRules = super.getTestRules(target);
        testRules.add(rule);
        return testRules;
    }
}

