/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jetty;

import com.github.mjeanroy.junit.servers.commons.reflect.Annotations;
import com.github.mjeanroy.junit.servers.commons.reflect.Classes;
import com.github.mjeanroy.junit.servers.engine.Servers;
import com.github.mjeanroy.junit.servers.jetty.AbstractBaseEmbeddedJetty;
import com.github.mjeanroy.junit.servers.jetty.EmbeddedJettyConfiguration;
import com.github.mjeanroy.junit.servers.jetty.EmbeddedJettyConfigurationProvider;
import com.github.mjeanroy.junit.servers.jetty.IllegalJettyConfigurationException;
import com.github.mjeanroy.junit.servers.jetty.JettyConfiguration;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;

public abstract class AbstractEmbeddedJettyFactory<EMBEDDED_JETTY extends AbstractBaseEmbeddedJetty<?, EmbeddedJettyConfiguration>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractEmbeddedJettyFactory.class);

    public final EMBEDDED_JETTY instantiateFrom(Class<?> testClass) {
        return this.instantiateFrom(testClass, null);
    }

    public final EMBEDDED_JETTY instantiateFrom(Class<?> testClass, EmbeddedJettyConfiguration configuration) {
        log.debug("Instantiating embedded jetty for test class: {}", testClass);
        EmbeddedJettyConfiguration configurationToUse = this.extractConfiguration(testClass, configuration);
        return configurationToUse == null ? this.instantiateFrom() : this.instantiateFrom(configurationToUse);
    }

    protected abstract EMBEDDED_JETTY instantiateFrom();

    protected abstract EMBEDDED_JETTY instantiateFrom(EmbeddedJettyConfiguration var1);

    private EmbeddedJettyConfiguration extractConfiguration(Class<?> testClass, EmbeddedJettyConfiguration configuration) {
        if (configuration != null) {
            log.debug("Returning provided configuration instance: {}", configuration);
            return this.checkConfiguration(configuration);
        }
        Class<EmbeddedJettyConfigurationProvider> providerClass = this.findEmbeddedJettyConfigurationProvider(testClass);
        if (providerClass != null) {
            return this.buildEmbeddedJettyConfiguration(testClass, providerClass);
        }
        log.debug("Extracting configuration from given test class: {}", testClass);
        return this.checkConfiguration(Servers.findConfiguration(testClass));
    }

    private Class<? extends EmbeddedJettyConfigurationProvider> findEmbeddedJettyConfigurationProvider(Class<?> testClass) {
        JettyConfiguration configurationAnnotation = Annotations.findAnnotation(testClass, JettyConfiguration.class);
        return configurationAnnotation == null ? null : configurationAnnotation.providedBy();
    }

    private EmbeddedJettyConfiguration buildEmbeddedJettyConfiguration(Class<?> testClass, Class<? extends EmbeddedJettyConfigurationProvider> providerClass) {
        log.debug("Returning configuration provided by test class");
        EmbeddedJettyConfigurationProvider provider = Classes.instantiate(providerClass);
        return provider.build(testClass);
    }

    private EmbeddedJettyConfiguration checkConfiguration(Object configuration) {
        if (configuration == null) {
            return null;
        }
        if (!(configuration instanceof EmbeddedJettyConfiguration)) {
            log.error("Cannot instantiate embedded jetty using configuration {} because it does not extends {} class", configuration, EmbeddedJettyConfiguration.class);
            throw new IllegalJettyConfigurationException(EmbeddedJettyConfiguration.class);
        }
        return (EmbeddedJettyConfiguration)configuration;
    }
}

