/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public final class Annotations {
    private static final List<String> BLACKLISTED_PACKAGES = Arrays.asList("java.lang.", "org.junit.");

    private Annotations() {
    }

    static boolean isAnnotationPresent(Field field, Class<? extends Annotation> annotationClass) {
        return field != null && Annotations.findAnnotation(field, annotationClass) != null;
    }

    static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass) {
        return method != null && method.isAnnotationPresent(annotationClass);
    }

    public static Collection<Annotation> findAnnotations(Field field) {
        return Annotations.findAnnotationOn(field);
    }

    public static <T extends Annotation> T findAnnotation(Class<?> klass, Class<T> annotationClass) {
        Collection<T> annotations = Annotations.findAnnotationOn(klass, annotationClass);
        return (T)(annotations.isEmpty() ? null : (Annotation)annotations.iterator().next());
    }

    public static <T extends Annotation> T findAnnotation(Field field, Class<T> annotationClass) {
        Collection<T> annotations = Annotations.findAnnotationOn(field, annotationClass);
        return (T)(annotations.isEmpty() ? null : (Annotation)annotations.iterator().next());
    }

    private static <T extends Annotation> Collection<T> findAnnotations(Class<?> klass, Class<T> annotationClass) {
        return Annotations.findAnnotationOn(klass, annotationClass);
    }

    private static <T extends Annotation> Collection<T> findAnnotationOn(AnnotatedElement element, Class<T> annotationClass) {
        ArrayList<T> results = new ArrayList<T>();
        if (element == null) {
            return Collections.emptyList();
        }
        if (element.isAnnotationPresent(annotationClass)) {
            results.add(element.getAnnotation(annotationClass));
        }
        for (Annotation candidate : element.getAnnotations()) {
            T result;
            Class<? extends Annotation> candidateAnnotationType = candidate.annotationType();
            if (!Annotations.shouldScan(candidateAnnotationType) || (result = Annotations.findAnnotation(candidateAnnotationType, annotationClass)) == null) continue;
            results.add(result);
        }
        if (element instanceof Class) {
            Collection<T> subResults;
            Class<?> declaringClass;
            Collection<T> subResults2;
            Class klass = (Class)element;
            for (Class<?> intf : klass.getInterfaces()) {
                Collection<T> subResults3;
                if (!Annotations.shouldScan(intf) || (subResults3 = Annotations.findAnnotationOn(intf, annotationClass)).isEmpty()) continue;
                results.addAll(subResults3);
            }
            Class superClass = klass.getSuperclass();
            if (Annotations.shouldScan(superClass) && !(subResults2 = Annotations.findAnnotations(superClass, annotationClass)).isEmpty()) {
                results.addAll(subResults2);
            }
            if (Annotations.shouldScan(declaringClass = klass.getDeclaringClass()) && !(subResults = Annotations.findAnnotations(declaringClass, annotationClass)).isEmpty()) {
                results.addAll(subResults);
            }
        }
        return Collections.unmodifiableList(results);
    }

    private static Collection<Annotation> findAnnotationOn(AnnotatedElement element) {
        if (element == null) {
            return Collections.emptySet();
        }
        Collection<Annotation> elementAnnotations = Annotations.findWhitelistedElementAnnotations(element);
        LinkedHashSet<Annotation> results = new LinkedHashSet<Annotation>(elementAnnotations);
        for (Annotation annotation : elementAnnotations) {
            Class<? extends Annotation> candidateAnnotationType = annotation.annotationType();
            if (!Annotations.shouldScan(candidateAnnotationType)) continue;
            results.addAll(Annotations.findAnnotationOn(candidateAnnotationType));
        }
        if (element instanceof Class) {
            Class<?> declaringClass;
            Class klass = (Class)element;
            for (Class<?> intf : klass.getInterfaces()) {
                if (!Annotations.shouldScan(intf)) continue;
                results.addAll(Annotations.findAnnotationOn(intf));
            }
            Class clazz = klass.getSuperclass();
            if (Annotations.shouldScan(clazz)) {
                results.addAll(Annotations.findAnnotationOn(clazz));
            }
            if (Annotations.shouldScan(declaringClass = klass.getDeclaringClass())) {
                results.addAll(Annotations.findAnnotationOn(declaringClass));
            }
        }
        return Collections.unmodifiableSet(results);
    }

    private static Collection<Annotation> findWhitelistedElementAnnotations(AnnotatedElement annotatedElement) {
        Annotation[] annotations = annotatedElement.getAnnotations();
        ArrayList<Annotation> whitelistedAnnotations = new ArrayList<Annotation>(annotations.length);
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!Annotations.shouldScan(annotationType)) continue;
            whitelistedAnnotations.add(annotation);
        }
        return whitelistedAnnotations;
    }

    private static boolean shouldScan(Class<?> elementType) {
        if (elementType == null) {
            return false;
        }
        String name = elementType.getName();
        for (String pkg : BLACKLISTED_PACKAGES) {
            if (!name.startsWith(pkg)) continue;
            return false;
        }
        return true;
    }
}

