/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyFile;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyPart;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyString;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

final class HttpRequestBodyPartBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestBodyPartBuilder.class);
    private final HttpRequestBody body;
    private final Map<String, HttpHeader> headers;

    static HttpRequestBodyPartBuilder of(HttpRequestBody body) {
        return new HttpRequestBodyPartBuilder(body);
    }

    static HttpRequestBodyPartBuilder of(File file) {
        return new HttpRequestBodyPartBuilder(HttpRequestBodyFile.of(file));
    }

    static HttpRequestBodyPartBuilder of(Path path) {
        return new HttpRequestBodyPartBuilder(HttpRequestBodyFile.of(path));
    }

    static HttpRequestBodyPartBuilder of(String value) {
        return new HttpRequestBodyPartBuilder(HttpRequestBodyString.of(value));
    }

    private HttpRequestBodyPartBuilder(HttpRequestBody body) {
        this.body = Preconditions.notNull(body, "body");
        this.headers = new LinkedHashMap<String, HttpHeader>();
    }

    HttpRequestBodyPartBuilder addHeader(HttpHeader header) {
        log.trace("Attempt to add header: {}", header);
        Preconditions.notNull(header, "header");
        String key = header.getName().toLowerCase();
        if (Objects.equals(key, "content-type")) {
            log.error("Attempt to add content-type header: {}", header);
            throw new IllegalArgumentException(String.format("Header '%s' is forbidden, please specify Content-Type wuth request body", header.getName()));
        }
        if (this.headers.containsKey(key)) {
            log.error("Attempt to add duplicated header: {}", header);
            throw new IllegalStateException(String.format("Header '%s' is already defined", header.getName()));
        }
        log.trace("Adding header: {}", header);
        this.headers.put(header.getName().toLowerCase(), header);
        return this;
    }

    HttpRequestBodyPartBuilder addHeader(String name, String value) {
        return this.addHeader(HttpHeader.of(name, value));
    }

    HttpRequestBodyPartBuilder asFormData(String name) {
        Preconditions.notBlank(name, "name");
        return this.addHeader(HttpRequestBodyPartBuilder.createContentDispositionHeader(name, null));
    }

    HttpRequestBodyPartBuilder asFormData(String name, String filename) {
        Preconditions.notBlank(name, "name");
        Preconditions.notBlank(filename, "filename");
        return this.addHeader(HttpRequestBodyPartBuilder.createContentDispositionHeader(name, filename));
    }

    HttpRequestBodyPart build() {
        return HttpRequestBodyPart.of(this.body, this.headers.values());
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("body", this.body).append("headers", this.headers).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequestBodyPartBuilder) {
            HttpRequestBodyPartBuilder b = (HttpRequestBodyPartBuilder)o;
            return Objects.equals(this.body, b.body) && Objects.equals(this.headers, b.headers);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.body, this.headers);
    }

    private static HttpHeader createContentDispositionHeader(String name, String filename) {
        return HttpHeader.of("Content-Disposition", HttpRequestBodyPartBuilder.createContentDispositionHeaderValue(name, filename));
    }

    private static String createContentDispositionHeaderValue(String name, String filename) {
        ArrayList<String> parts = new ArrayList<String>(3);
        parts.add("form-data");
        parts.add("name=\"" + HttpRequestBodyPartBuilder.toEscapedString(name) + "\"");
        if (filename != null) {
            parts.add("filename=\"" + HttpRequestBodyPartBuilder.toEscapedString(filename) + "\"");
        }
        return String.join((CharSequence)"; ", parts);
    }

    private static String toEscapedString(String input) {
        int size = input.length();
        StringBuilder output = new StringBuilder(size * 3);
        block5: for (int i = 0; i < size; ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case '\n': {
                    output.append("%0A");
                    continue block5;
                }
                case '\r': {
                    output.append("%0D");
                    continue block5;
                }
                case '\"': {
                    output.append("%22");
                    continue block5;
                }
                default: {
                    output.append(ch);
                }
            }
        }
        return output.toString();
    }
}

