/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.commons.lang;

import com.thebuzzmedia.exiftool.exceptions.UnreadableFileException;
import com.thebuzzmedia.exiftool.exceptions.UnwritableFileException;
import java.io.File;
import java.util.Map;
import java.util.Objects;

public final class PreConditions {
    private PreConditions() {
    }

    public static String notBlank(String val, String message) {
        Objects.requireNonNull(val, message);
        if (val.length() == 0 || val.trim().length() == 0) {
            throw new IllegalArgumentException(message);
        }
        return val;
    }

    public static <T> T[] notEmpty(T[] val, String message) {
        Objects.requireNonNull(val, message);
        if (val.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return val;
    }

    public static <T, U> Map<T, U> notEmpty(Map<T, U> val, String message) {
        Objects.requireNonNull(val, message);
        if (val.size() == 0) {
            throw new IllegalArgumentException(message);
        }
        return val;
    }

    public static <T> Iterable<T> notEmpty(Iterable<T> val, String message) {
        Objects.requireNonNull(val, message);
        if (!val.iterator().hasNext()) {
            throw new IllegalArgumentException(message);
        }
        return val;
    }

    public static <T extends Number> T isPositive(T nb, String message) {
        Objects.requireNonNull(nb, message);
        if (nb.doubleValue() <= 0.0) {
            throw new IllegalArgumentException(message);
        }
        return nb;
    }

    public static File isReadable(File file, String message) {
        Objects.requireNonNull(file, message);
        if (!file.exists() || !file.canRead()) {
            throw new UnreadableFileException(file, message);
        }
        return file;
    }

    public static File isWritable(File file, String message) {
        Objects.requireNonNull(file, message);
        if (!file.exists() || !file.canWrite()) {
            throw new UnwritableFileException(file, message);
        }
        return file;
    }

    private static String errorMessage(String message, Object[] params) {
        return params.length > 0 ? String.format(message, params) : message;
    }
}

