/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.cache;

import com.thebuzzmedia.exiftool.Version;
import com.thebuzzmedia.exiftool.exceptions.ExifToolNotFoundException;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.Command;
import com.thebuzzmedia.exiftool.process.CommandExecutor;
import com.thebuzzmedia.exiftool.process.CommandResult;
import com.thebuzzmedia.exiftool.process.command.CommandBuilder;
import com.thebuzzmedia.exiftool.process.executor.DefaultCommandExecutor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;

class VersionCallable
implements Callable<Version> {
    private static final Logger log = LoggerFactory.getLogger(VersionCallable.class);
    private final String exifTool;
    private final WeakReference<CommandExecutor> executor;

    VersionCallable(String exifTool, CommandExecutor executor) {
        this.exifTool = exifTool;
        this.executor = new WeakReference<CommandExecutor>(executor);
    }

    @Override
    public Version call() {
        log.debug("Checking exiftool (path: {}) version", this.exifTool);
        try {
            Command cmd;
            CommandResult result;
            CommandExecutor commandExecutor = (CommandExecutor)this.executor.get();
            if (commandExecutor == null) {
                log.warn("Command executor has already been garbage collected, run exiftool with a default executor");
                commandExecutor = new DefaultCommandExecutor();
            }
            if (!(result = commandExecutor.execute(cmd = CommandBuilder.builder(this.exifTool, 1).addArgument("-ver", new String[0]).build())).isSuccess()) {
                throw new ExifToolNotFoundException(this.exifTool, result);
            }
            return new Version(result.getOutput());
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), ex);
            throw new ExifToolNotFoundException(ex, this.exifTool);
        }
    }
}

