/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool;

import com.thebuzzmedia.exiftool.ExecutionStrategy;
import com.thebuzzmedia.exiftool.ExifToolOptions;
import com.thebuzzmedia.exiftool.Format;
import com.thebuzzmedia.exiftool.Tag;
import com.thebuzzmedia.exiftool.Version;
import com.thebuzzmedia.exiftool.VersionCache;
import com.thebuzzmedia.exiftool.commons.iterables.Collections;
import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import com.thebuzzmedia.exiftool.core.StandardFormat;
import com.thebuzzmedia.exiftool.core.StandardOptions;
import com.thebuzzmedia.exiftool.core.UnspecifiedTag;
import com.thebuzzmedia.exiftool.core.cache.VersionCacheFactory;
import com.thebuzzmedia.exiftool.core.handlers.AllTagHandler;
import com.thebuzzmedia.exiftool.core.handlers.StandardTagHandler;
import com.thebuzzmedia.exiftool.core.handlers.StopHandler;
import com.thebuzzmedia.exiftool.core.handlers.TagHandler;
import com.thebuzzmedia.exiftool.exceptions.UnsupportedFeatureException;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.CommandExecutor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExifTool
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ExifTool.class);
    private static final VersionCache cache = VersionCacheFactory.newCache();
    private final CommandExecutor executor;
    private final String path;
    private final Version version;
    private final ExecutionStrategy strategy;

    ExifTool(String path, CommandExecutor executor, ExecutionStrategy strategy) {
        this.executor = PreConditions.notNull(executor, "Executor should not be null", new Object[0]);
        this.path = PreConditions.notBlank(path, "ExifTool path should not be null", new Object[0]);
        this.strategy = PreConditions.notNull(strategy, "Execution strategy should not be null", new Object[0]);
        this.version = cache.load(path, executor);
        if (!strategy.isSupported(this.version)) {
            throw new UnsupportedFeatureException(path, this.version);
        }
    }

    @Override
    public void close() throws Exception {
        this.strategy.shutdown();
    }

    public void stop() throws Exception {
        this.strategy.close();
    }

    public boolean isRunning() {
        return this.strategy.isRunning();
    }

    public Version getVersion() {
        return this.version;
    }

    public Map<Tag, String> getImageMeta(File image) throws IOException {
        return this.getImageMeta(image, StandardFormat.NUMERIC);
    }

    public Map<Tag, String> getImageMeta(File image, Format format) throws IOException {
        StandardOptions options = StandardOptions.builder().withFormat(format).build();
        return this.getImageMeta(image, options);
    }

    public Map<Tag, String> getImageMeta(File image, ExifToolOptions options) throws IOException {
        log.debug("Querying all tags from image: {}", image);
        UnspecifiedTag all = new UnspecifiedTag("All");
        Set<UnspecifiedTag> tags = java.util.Collections.singleton(all);
        return this.getImageMeta(image, tags, options, new AllTagHandler());
    }

    public Map<Tag, String> getImageMeta(File image, Collection<Tag> tags) throws IOException {
        return this.getImageMeta(image, StandardFormat.NUMERIC, tags);
    }

    public Map<Tag, String> getImageMeta(File image, Format format, Collection<? extends Tag> tags) throws IOException {
        PreConditions.notNull(format, "Format cannot be null.", new Object[0]);
        StandardOptions options = StandardOptions.builder().withFormat(format).build();
        return this.getImageMeta(image, options, tags);
    }

    public Map<Tag, String> getImageMeta(File image, ExifToolOptions options, Collection<? extends Tag> tags) throws IOException {
        PreConditions.notNull(options, "Options cannot be null.", new Object[0]);
        PreConditions.notEmpty(tags, "Tags cannot be null and must contain 1 or more Tag to query the image for.", new Object[0]);
        log.debug("Querying {} tags from image: {}", tags.size(), image);
        StandardTagHandler tagHandler = new StandardTagHandler(tags);
        return this.getImageMeta(image, tags, options, tagHandler);
    }

    private Map<Tag, String> getImageMeta(File image, Collection<? extends Tag> tags, ExifToolOptions options, TagHandler tagHandler) throws IOException {
        PreConditions.notNull(image, "Image cannot be null and must be a valid stream of image data.", new Object[0]);
        PreConditions.notNull(options, "Options cannot be null.", new Object[0]);
        PreConditions.isReadable(image, "Unable to read the given image [%s], ensure that the image exists at the given withPath and that the executing Java process has permissions to read it.", image);
        List<String> args = this.toArguments(image, tags, options);
        this.strategy.execute(this.executor, this.path, args, tagHandler);
        log.debug("Image Meta Processed [queried {}, found {} values]", tagHandler.size(), tagHandler.size());
        return tagHandler.getTags();
    }

    public void setImageMeta(File image, Map<? extends Tag, String> tags) throws IOException {
        this.setImageMeta(image, StandardFormat.NUMERIC, tags);
    }

    public void setImageMeta(File image, Format format, Map<? extends Tag, String> tags) throws IOException {
        PreConditions.notNull(format, "Format cannot be null.", new Object[0]);
        StandardOptions options = StandardOptions.builder().withFormat(format).build();
        this.setImageMeta(image, options, tags);
    }

    public void setImageMeta(File image, ExifToolOptions options, Map<? extends Tag, String> tags) throws IOException {
        PreConditions.notNull(image, "Image cannot be null and must be a valid stream of image data.", new Object[0]);
        PreConditions.notNull(options, "Options cannot be null.", new Object[0]);
        PreConditions.notEmpty(tags, "Tags cannot be null and must contain 1 or more Tag to query the image for.", new Object[0]);
        PreConditions.isWritable(image, "Unable to read the given image [%s], ensure that the image exists at the given withPath and that the executing Java process has permissions to read it.", image);
        log.debug("Writing {} tags to image: {}", tags.size(), image);
        long startTime = System.currentTimeMillis();
        List<String> args = this.toArguments(image, tags, options);
        this.strategy.execute(this.executor, this.path, args, StopHandler.stopHandler());
        log.debug("Image Meta Processed in {} ms [write {} tags]", System.currentTimeMillis() - startTime, tags.size());
    }

    private List<String> toArguments(File image, Collection<? extends Tag> tags, ExifToolOptions options) {
        ArrayList<String> tagArgs = new ArrayList<String>(tags.size());
        for (Tag tag : tags) {
            tagArgs.add("-" + tag.getName());
        }
        return this.toArguments(image, options, tagArgs);
    }

    private List<String> toArguments(File image, Map<? extends Tag, String> tags, ExifToolOptions options) {
        ArrayList<String> tagArgs = new ArrayList<String>(tags.size());
        for (Map.Entry<? extends Tag, String> entry : tags.entrySet()) {
            tagArgs.add("-" + entry.getKey().getName() + "=" + entry.getValue());
        }
        return this.toArguments(image, options, tagArgs);
    }

    private List<String> toArguments(File image, ExifToolOptions options, List<String> tags) {
        Collection<String> optionArgs = Collections.toCollection(options.serialize());
        int expectedSize = optionArgs.size() + tags.size() + 3;
        ArrayList<String> args = new ArrayList<String>(expectedSize);
        Collections.addAll(args, optionArgs);
        args.add("-S");
        args.addAll(tags);
        args.add(image.getAbsolutePath());
        args.add("-execute");
        return new ArrayList<String>(args);
    }
}

