/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.server.http;

import android.util.Log;
import android.util.LruCache;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.server.http.UsbFileProvider;
import com.github.mjdev.libaums.server.http.exception.NotAFileException;
import com.github.mjdev.libaums.server.http.server.HttpServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/mjdev/libaums/server/http/UsbFileHttpServer;", "Lcom/github/mjdev/libaums/server/http/UsbFileProvider;", "rootFile", "Lcom/github/mjdev/libaums/fs/UsbFile;", "server", "Lcom/github/mjdev/libaums/server/http/server/HttpServer;", "(Lcom/github/mjdev/libaums/fs/UsbFile;Lcom/github/mjdev/libaums/server/http/server/HttpServer;)V", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "fileCache", "Landroid/util/LruCache;", "isAlive", "", "()Z", "determineFileToServe", "uri", "start", "", "stop", "Companion", "libaums-httpserver_release"})
public final class UsbFileHttpServer
implements UsbFileProvider {
    private final LruCache<String, UsbFile> fileCache;
    private final UsbFile rootFile;
    private final HttpServer server;
    private static final String TAG;
    public static final Companion Companion;

    @NotNull
    public final String getBaseUrl() {
        String hostname = this.server.getHostname();
        if (hostname == null) {
            hostname = "localhost";
        }
        return "http://" + hostname + ":" + this.server.getListeningPort() + "/";
    }

    public final boolean isAlive() {
        return this.server.isAlive();
    }

    public final void start() throws IOException {
        this.server.start();
    }

    public final void stop() throws IOException {
        this.server.stop();
        this.fileCache.evictAll();
    }

    @Override
    @NotNull
    public UsbFile determineFileToServe(@NotNull String uri) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        UsbFile fileToServe = (UsbFile)this.fileCache.get((Object)uri);
        if (fileToServe == null) {
            Log.d((String)TAG, (String)("Searching file on USB (URI: " + uri + ')'));
            if (!this.rootFile.isDirectory()) {
                Log.d((String)TAG, (String)"Serving root file");
                if (Intrinsics.areEqual((Object)"/", (Object)uri) ^ true && Intrinsics.areEqual((Object)("/" + this.rootFile.getName()), (Object)uri) ^ true) {
                    Log.d((String)TAG, (String)"Invalid request, respond with 404");
                    throw (Throwable)new FileNotFoundException("Not found " + uri);
                }
                fileToServe = this.rootFile;
            } else {
                String string = uri;
                int n = 1;
                UsbFile usbFile = this.rootFile;
                boolean bl = false;
                String string2 = string.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                String string3 = string2;
                fileToServe = usbFile.search(string3);
            }
        } else {
            Log.d((String)TAG, (String)("Using lru cache for " + uri));
        }
        if (fileToServe == null) {
            Log.d((String)TAG, (String)"fileToServe == null");
            throw (Throwable)new FileNotFoundException("Not found " + uri);
        }
        if (fileToServe.isDirectory()) {
            throw (Throwable)new NotAFileException();
        }
        this.fileCache.put((Object)uri, (Object)fileToServe);
        return fileToServe;
    }

    public UsbFileHttpServer(@NotNull UsbFile rootFile, @NotNull HttpServer server) {
        Intrinsics.checkParameterIsNotNull((Object)rootFile, (String)"rootFile");
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        this.rootFile = rootFile;
        this.server = server;
        this.fileCache = new LruCache(100);
        this.server.setUsbFileProvider(this);
    }

    static {
        Companion = new Companion(null);
        String string = UsbFileHttpServer.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UsbFileHttpServer::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/mjdev/libaums/server/http/UsbFileHttpServer$Companion;", "", "()V", "TAG", "", "libaums-httpserver_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

