/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import com.github.mjdev.libaums.usb.AndroidUsbCommunication;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0010H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/mjdev/libaums/usb/UsbRequestCommunication;", "Lcom/github/mjdev/libaums/usb/AndroidUsbCommunication;", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "outEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "inEndpoint", "(Landroid/hardware/usb/UsbManager;Landroid/hardware/usb/UsbDevice;Landroid/hardware/usb/UsbInterface;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "inRequest", "Landroid/hardware/usb/UsbRequest;", "outRequest", "workaroundBuffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "bulkInTransfer", "", "dest", "bulkOutTransfer", "src", "libaums_release"})
public final class UsbRequestCommunication
extends AndroidUsbCommunication {
    private final UsbRequest outRequest;
    private final UsbRequest inRequest;
    private final ByteBuffer workaroundBuffer;

    @Override
    public synchronized int bulkOutTransfer(@NotNull ByteBuffer src) throws IOException {
        UsbRequest request;
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        int length = src.remaining();
        int oldPosition = src.position();
        this.workaroundBuffer.clear();
        this.workaroundBuffer.put(src);
        if (!this.outRequest.queue(this.workaroundBuffer, length)) {
            throw (Throwable)new IOException("Error queueing request.");
        }
        UsbDeviceConnection usbDeviceConnection = this.getDeviceConnection();
        if (usbDeviceConnection == null) {
            Intrinsics.throwNpe();
        }
        if ((request = usbDeviceConnection.requestWait()) == this.outRequest) {
            src.position(oldPosition + this.workaroundBuffer.position());
            return this.workaroundBuffer.position();
        }
        throw (Throwable)new IOException("requestWait failed! Request: " + request);
    }

    @Override
    public synchronized int bulkInTransfer(@NotNull ByteBuffer dest) throws IOException {
        UsbRequest request;
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        int length = dest.remaining();
        this.workaroundBuffer.clear();
        this.workaroundBuffer.limit(length);
        if (!this.inRequest.queue(this.workaroundBuffer, length)) {
            throw (Throwable)new IOException("Error queueing request.");
        }
        UsbDeviceConnection usbDeviceConnection = this.getDeviceConnection();
        if (usbDeviceConnection == null) {
            Intrinsics.throwNpe();
        }
        if ((request = usbDeviceConnection.requestWait()) == this.inRequest) {
            this.workaroundBuffer.flip();
            dest.put(this.workaroundBuffer);
            return this.workaroundBuffer.limit();
        }
        throw (Throwable)new IOException("requestWait failed! Request: " + request);
    }

    public UsbRequestCommunication(@NotNull UsbManager usbManager, @NotNull UsbDevice usbDevice, @NotNull UsbInterface usbInterface, @NotNull UsbEndpoint outEndpoint, @NotNull UsbEndpoint inEndpoint) {
        UsbRequest usbRequest;
        Intrinsics.checkParameterIsNotNull((Object)usbManager, (String)"usbManager");
        Intrinsics.checkParameterIsNotNull((Object)usbDevice, (String)"usbDevice");
        Intrinsics.checkParameterIsNotNull((Object)usbInterface, (String)"usbInterface");
        Intrinsics.checkParameterIsNotNull((Object)outEndpoint, (String)"outEndpoint");
        Intrinsics.checkParameterIsNotNull((Object)inEndpoint, (String)"inEndpoint");
        super(usbManager, usbDevice, usbInterface, outEndpoint, inEndpoint);
        UsbRequest usbRequest2 = new UsbRequest();
        UsbRequestCommunication usbRequestCommunication = this;
        boolean bl = false;
        boolean bl2 = false;
        UsbRequest $this$apply = usbRequest2;
        boolean bl3 = false;
        $this$apply.initialize(this.getDeviceConnection(), outEndpoint);
        usbRequestCommunication.outRequest = usbRequest = usbRequest2;
        usbRequest2 = new UsbRequest();
        usbRequestCommunication = this;
        bl = false;
        bl2 = false;
        $this$apply = usbRequest2;
        boolean bl4 = false;
        $this$apply.initialize(this.getDeviceConnection(), inEndpoint);
        usbRequestCommunication.inRequest = usbRequest = usbRequest2;
        this.workaroundBuffer = ByteBuffer.allocate(131072);
    }
}

