/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.github.mjdev.libaums.ErrNo;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\t\b \u0018\u0000 /2\u00020\u0001:\u0001/B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0019\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001eH\u0082 J\b\u0010\u001f\u001a\u00020\u0019H\u0016J\b\u0010 \u001a\u00020\u0019H\u0002J8\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001eH\u0016J\b\u0010)\u001a\u00020\u0019H\u0002J\b\u0010*\u001a\u00020\u0019H\u0002J\b\u0010+\u001a\u00020\u0019H\u0002J\b\u0010,\u001a\u00020\u0019H\u0016J\u0011\u0010-\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0082 J\b\u0010.\u001a\u00020\u0019H\u0002R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/github/mjdev/libaums/usb/AndroidUsbCommunication;", "Lcom/github/mjdev/libaums/usb/UsbCommunication;", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "outEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "inEndpoint", "(Landroid/hardware/usb/UsbManager;Landroid/hardware/usb/UsbDevice;Landroid/hardware/usb/UsbInterface;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "deviceConnection", "Landroid/hardware/usb/UsbDeviceConnection;", "getDeviceConnection", "()Landroid/hardware/usb/UsbDeviceConnection;", "setDeviceConnection", "(Landroid/hardware/usb/UsbDeviceConnection;)V", "getInEndpoint", "()Landroid/hardware/usb/UsbEndpoint;", "isClosed", "", "isNativeInited", "getOutEndpoint", "bulkOnlyMassStorageReset", "", "clearFeatureHalt", "endpoint", "clearHaltNative", "fd", "", "close", "closeUsbConnection", "controlTransfer", "requestType", "request", "value", "index", "buffer", "", "length", "initNativeLibrary", "initUsbConnection", "nativeReset", "resetRecovery", "resetUsbDeviceNative", "softReset", "Companion", "libaums_release"})
public abstract class AndroidUsbCommunication
implements UsbCommunication {
    private boolean isNativeInited;
    @Nullable
    private UsbDeviceConnection deviceConnection;
    private boolean isClosed;
    private final UsbManager usbManager;
    private final UsbDevice usbDevice;
    private final UsbInterface usbInterface;
    @NotNull
    private final UsbEndpoint outEndpoint;
    @NotNull
    private final UsbEndpoint inEndpoint;
    private static final String TAG;
    public static final Companion Companion;

    @Nullable
    public final UsbDeviceConnection getDeviceConnection() {
        return this.deviceConnection;
    }

    public final void setDeviceConnection(@Nullable UsbDeviceConnection usbDeviceConnection) {
        this.deviceConnection = usbDeviceConnection;
    }

    private final void initUsbConnection() {
        boolean claim;
        if (this.isClosed) {
            return;
        }
        Log.d((String)TAG, (String)"setup device");
        UsbDeviceConnection usbDeviceConnection = this.usbManager.openDevice(this.usbDevice);
        if (usbDeviceConnection == null) {
            throw (Throwable)new IOException("deviceConnection is null!");
        }
        UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection = usbDeviceConnection;
        if (usbDeviceConnection2 == null) {
            Intrinsics.throwNpe();
        }
        if (!(claim = usbDeviceConnection2.claimInterface(this.usbInterface, true))) {
            throw (Throwable)new IOException("could not claim interface!");
        }
    }

    private final void initNativeLibrary() {
        try {
            System.loadLibrary("usb-lib");
            this.isNativeInited = true;
        }
        catch (UnsatisfiedLinkError e) {
            this.isNativeInited = false;
            Log.e((String)TAG, (String)"could not load usb-lib", (Throwable)e);
        }
    }

    @Override
    public int controlTransfer(int requestType, int request, int value, int index, @NotNull byte[] buffer, int length) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        if (usbDeviceConnection == null) {
            Intrinsics.throwNpe();
        }
        return usbDeviceConnection.controlTransfer(requestType, request, value, index, buffer, length, 5000);
    }

    @Override
    public void resetRecovery() {
        if (this.isNativeInited) {
            this.nativeReset();
        } else {
            this.softReset();
        }
    }

    private final void nativeReset() {
        Log.d((String)TAG, (String)"Performing native reset");
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        if (usbDeviceConnection == null) {
            Intrinsics.throwNpe();
        }
        if (!usbDeviceConnection.releaseInterface(this.usbInterface)) {
            Log.w((String)TAG, (String)("Failed to release interface, errno: " + ErrNo.INSTANCE.getErrno() + ' ' + ErrNo.INSTANCE.getErrstr()));
        }
        UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection;
        if (usbDeviceConnection2 == null) {
            Intrinsics.throwNpe();
        }
        if (!this.resetUsbDeviceNative(usbDeviceConnection2.getFileDescriptor())) {
            Log.w((String)TAG, (String)("ioctl failed! errno " + ErrNo.INSTANCE.getErrno() + ' ' + ErrNo.INSTANCE.getErrstr()));
            Log.w((String)TAG, (String)"USB device will likely require new discovery and permissions");
        }
        UsbDeviceConnection usbDeviceConnection3 = this.deviceConnection;
        if (usbDeviceConnection3 == null) {
            Intrinsics.throwNpe();
        }
        if (!usbDeviceConnection3.claimInterface(this.usbInterface, true)) {
            throw (Throwable)new IOException("Could not claim interface, errno: " + ErrNo.INSTANCE.getErrno() + ' ' + ErrNo.INSTANCE.getErrstr());
        }
    }

    private final void softReset() {
        this.bulkOnlyMassStorageReset();
        Thread.sleep(2000L);
        this.clearFeatureHalt(this.getInEndpoint());
        Thread.sleep(2000L);
        this.clearFeatureHalt(this.getOutEndpoint());
        Thread.sleep(2000L);
    }

    @Override
    public void bulkOnlyMassStorageReset() {
        Log.w((String)TAG, (String)"sending bulk only mass storage request");
        byte[] bArr = new byte[2];
        int transferred = this.controlTransfer(33, 255, 0, this.usbInterface.getId(), bArr, 0);
        if (transferred == -1) {
            throw (Throwable)new IOException("bulk only mass storage reset failed!");
        }
    }

    @Override
    public void clearFeatureHalt(@NotNull UsbEndpoint endpoint) {
        boolean result;
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Log.w((String)TAG, (String)("Clearing halt on endpoint " + endpoint + " (direction " + endpoint.getDirection() + ')'));
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        if (usbDeviceConnection == null) {
            Intrinsics.throwNpe();
        }
        if (!(result = this.clearHaltNative(usbDeviceConnection.getFileDescriptor(), endpoint.getAddress()))) {
            Log.e((String)TAG, (String)("Clear halt failed: errno " + ErrNo.INSTANCE.getErrno() + ' ' + ErrNo.INSTANCE.getErrstr()));
        }
    }

    private final void closeUsbConnection() {
        boolean release;
        if (this.deviceConnection == null) {
            return;
        }
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        if (usbDeviceConnection == null) {
            Intrinsics.throwNpe();
        }
        if (!(release = usbDeviceConnection.releaseInterface(this.usbInterface))) {
            Log.e((String)TAG, (String)"could not release interface!");
        }
        UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection;
        if (usbDeviceConnection2 == null) {
            Intrinsics.throwNpe();
        }
        usbDeviceConnection2.close();
    }

    @Override
    public void close() {
        Log.d((String)TAG, (String)"close device");
        this.closeUsbConnection();
        this.isClosed = true;
    }

    private final native boolean resetUsbDeviceNative(int var1);

    private final native boolean clearHaltNative(int var1, int var2);

    @Override
    @NotNull
    public UsbEndpoint getOutEndpoint() {
        return this.outEndpoint;
    }

    @Override
    @NotNull
    public UsbEndpoint getInEndpoint() {
        return this.inEndpoint;
    }

    public AndroidUsbCommunication(@NotNull UsbManager usbManager, @NotNull UsbDevice usbDevice, @NotNull UsbInterface usbInterface, @NotNull UsbEndpoint outEndpoint, @NotNull UsbEndpoint inEndpoint) {
        Intrinsics.checkParameterIsNotNull((Object)usbManager, (String)"usbManager");
        Intrinsics.checkParameterIsNotNull((Object)usbDevice, (String)"usbDevice");
        Intrinsics.checkParameterIsNotNull((Object)usbInterface, (String)"usbInterface");
        Intrinsics.checkParameterIsNotNull((Object)outEndpoint, (String)"outEndpoint");
        Intrinsics.checkParameterIsNotNull((Object)inEndpoint, (String)"inEndpoint");
        this.usbManager = usbManager;
        this.usbDevice = usbDevice;
        this.usbInterface = usbInterface;
        this.outEndpoint = outEndpoint;
        this.inEndpoint = inEndpoint;
        this.initNativeLibrary();
        this.initUsbConnection();
    }

    static {
        Companion = new Companion(null);
        String string = AndroidUsbCommunication.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"AndroidUsbCommunication::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/mjdev/libaums/usb/AndroidUsbCommunication$Companion;", "", "()V", "TAG", "", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

