/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.UsbFileInputStream;
import com.github.mjdev.libaums.fs.UsbFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/github/mjdev/libaums/fs/UsbFileStreamFactory;", "", "()V", "createBufferedInputStream", "Ljava/io/BufferedInputStream;", "file", "Lcom/github/mjdev/libaums/fs/UsbFile;", "fs", "Lcom/github/mjdev/libaums/fs/FileSystem;", "createBufferedOutputStream", "Ljava/io/BufferedOutputStream;", "libaums_release"})
public final class UsbFileStreamFactory {
    public static final UsbFileStreamFactory INSTANCE;

    @JvmStatic
    @NotNull
    public static final BufferedOutputStream createBufferedOutputStream(@NotNull UsbFile file, @NotNull FileSystem fs) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        return new BufferedOutputStream(new UsbFileOutputStream(file, false, 2, null), fs.getChunkSize());
    }

    @JvmStatic
    @NotNull
    public static final BufferedInputStream createBufferedInputStream(@NotNull UsbFile file, @NotNull FileSystem fs) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        return new BufferedInputStream(new UsbFileInputStream(file), fs.getChunkSize());
    }

    private UsbFileStreamFactory() {
    }

    static {
        UsbFileStreamFactory usbFileStreamFactory;
        INSTANCE = usbFileStreamFactory = new UsbFileStreamFactory();
    }
}

