/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.BlockDeviceDriverFactory;
import com.github.mjdev.libaums.driver.scsi.UnitNotReady;
import com.github.mjdev.libaums.partition.Partition;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import com.github.mjdev.libaums.partition.PartitionTableFactory;
import com.github.mjdev.libaums.usb.UsbCommunication;
import com.github.mjdev.libaums.usb.UsbCommunicationFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001aH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/mjdev/libaums/UsbMassStorageDevice;", "", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "inEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "outEndpoint", "(Landroid/hardware/usb/UsbManager;Landroid/hardware/usb/UsbDevice;Landroid/hardware/usb/UsbInterface;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "deviceConnection", "Landroid/hardware/usb/UsbDeviceConnection;", "inited", "", "partitions", "", "Lcom/github/mjdev/libaums/partition/Partition;", "getPartitions", "()Ljava/util/List;", "setPartitions", "(Ljava/util/List;)V", "getUsbDevice", "()Landroid/hardware/usb/UsbDevice;", "close", "", "init", "initPartitions", "partitionTable", "Lcom/github/mjdev/libaums/partition/PartitionTable;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "setupDevice", "Companion", "libaums_release"})
public final class UsbMassStorageDevice {
    private UsbDeviceConnection deviceConnection;
    @NotNull
    public List<Partition> partitions;
    private boolean inited;
    private final UsbManager usbManager;
    @NotNull
    private final UsbDevice usbDevice;
    private final UsbInterface usbInterface;
    private final UsbEndpoint inEndpoint;
    private final UsbEndpoint outEndpoint;
    private static final String TAG;
    private static final int INTERFACE_SUBCLASS = 6;
    private static final int INTERFACE_PROTOCOL = 80;
    public static final Companion Companion;

    @NotNull
    public final List<Partition> getPartitions() {
        List<Partition> list = this.partitions;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"partitions");
        }
        return list;
    }

    public final void setPartitions(@NotNull List<Partition> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.partitions = list;
    }

    public final void init() throws IOException {
        if (!this.usbManager.hasPermission(this.usbDevice)) {
            throw (Throwable)new IllegalStateException("Missing permission to access usb device: " + this.usbDevice);
        }
        this.setupDevice();
        this.inited = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupDevice() throws IOException {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection<BlockDeviceDriver> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        boolean claim;
        Log.d((String)TAG, (String)"setup device");
        UsbDeviceConnection usbDeviceConnection = this.usbManager.openDevice(this.usbDevice);
        if (usbDeviceConnection == null) {
            throw (Throwable)new IOException("deviceConnection is null!");
        }
        UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection = usbDeviceConnection;
        if (usbDeviceConnection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceConnection");
        }
        if (!(claim = usbDeviceConnection2.claimInterface(this.usbInterface, true))) {
            throw (Throwable)new IOException("could not claim interface!");
        }
        UsbDeviceConnection usbDeviceConnection3 = this.deviceConnection;
        if (usbDeviceConnection3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceConnection");
        }
        UsbCommunication communication = UsbCommunicationFactory.INSTANCE.createUsbCommunication(usbDeviceConnection3, this.outEndpoint, this.inEndpoint);
        byte[] maxLun = new byte[1];
        UsbDeviceConnection usbDeviceConnection4 = this.deviceConnection;
        if (usbDeviceConnection4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceConnection");
        }
        usbDeviceConnection4.controlTransfer(161, 254, 0, this.usbInterface.getId(), maxLun, 1, 5000);
        Log.i((String)TAG, (String)("MAX LUN " + maxLun[0]));
        int n = 0;
        Iterable iterable = (Iterable)new IntRange(n, (int)maxLun[0]);
        UsbMassStorageDevice usbMassStorageDevice = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void lun;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            BlockDeviceDriver blockDeviceDriver = BlockDeviceDriverFactory.INSTANCE.createBlockDevice(communication, (byte)lun);
            collection.add(blockDeviceDriver);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List<Partition> list;
            block10: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                BlockDeviceDriver blockDevice = (BlockDeviceDriver)element$iv$iv;
                boolean bl2 = false;
                try {
                    blockDevice.init();
                }
                catch (UnitNotReady e) {
                    if (maxLun[0] == (byte)0) {
                        throw (Throwable)e;
                    }
                    list = null;
                    break block10;
                }
                PartitionTable partitionTable = PartitionTableFactory.INSTANCE.createPartitionTable(blockDevice);
                list = this.initPartitions(partitionTable, blockDevice);
            }
            if (list == null) continue;
            List<Partition> list2 = list;
            boolean bl = false;
            boolean bl3 = false;
            List<Partition> it$iv$iv = list2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        collection = (List)destination$iv$iv;
        usbMassStorageDevice.partitions = CollectionsKt.flatten((Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Partition> initPartitions(PartitionTable partitionTable, BlockDeviceDriver blockDevice) throws IOException {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = partitionTable.getPartitionTableEntries();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Partition partition;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PartitionTableEntry it = (PartitionTableEntry)element$iv$iv;
            boolean bl2 = false;
            if (Partition.Companion.createPartition(it, blockDevice) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Partition it$iv$iv = partition;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void close() {
        boolean release;
        Log.d((String)TAG, (String)"close device");
        if (this.deviceConnection == null) {
            return;
        }
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        if (usbDeviceConnection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceConnection");
        }
        if (!(release = usbDeviceConnection.releaseInterface(this.usbInterface))) {
            Log.e((String)TAG, (String)"could not release interface!");
        }
        UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection;
        if (usbDeviceConnection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceConnection");
        }
        usbDeviceConnection2.close();
        this.inited = false;
    }

    @NotNull
    public final UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    private UsbMassStorageDevice(UsbManager usbManager, UsbDevice usbDevice, UsbInterface usbInterface, UsbEndpoint inEndpoint, UsbEndpoint outEndpoint) {
        this.usbManager = usbManager;
        this.usbDevice = usbDevice;
        this.usbInterface = usbInterface;
        this.inEndpoint = inEndpoint;
        this.outEndpoint = outEndpoint;
    }

    static {
        Companion = new Companion(null);
        String string = UsbMassStorageDevice.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UsbMassStorageDevice::class.java.simpleName");
        TAG = string;
    }

    public static final /* synthetic */ UsbDeviceConnection access$getDeviceConnection$p(UsbMassStorageDevice $this) {
        UsbDeviceConnection usbDeviceConnection = $this.deviceConnection;
        if (usbDeviceConnection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceConnection");
        }
        return usbDeviceConnection;
    }

    public static final /* synthetic */ void access$setDeviceConnection$p(UsbMassStorageDevice $this, UsbDeviceConnection usbDeviceConnection) {
        $this.deviceConnection = usbDeviceConnection;
    }

    public /* synthetic */ UsbMassStorageDevice(UsbManager usbManager, UsbDevice usbDevice, UsbInterface usbInterface, UsbEndpoint inEndpoint, UsbEndpoint outEndpoint, DefaultConstructorMarker $constructor_marker) {
        this(usbManager, usbDevice, usbInterface, inEndpoint, outEndpoint);
    }

    @JvmStatic
    @NotNull
    public static final List<UsbMassStorageDevice> getMassStorageDevices(@NotNull UsbDevice $this$getMassStorageDevices, @NotNull Context context) {
        return Companion.getMassStorageDevices($this$getMassStorageDevices, context);
    }

    @JvmStatic
    @NotNull
    public static final UsbMassStorageDevice[] getMassStorageDevices(@NotNull Context context) {
        return Companion.getMassStorageDevices(context);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u000e*\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/mjdev/libaums/UsbMassStorageDevice$Companion;", "", "()V", "INTERFACE_PROTOCOL", "", "INTERFACE_SUBCLASS", "TAG", "", "getMassStorageDevices", "", "Lcom/github/mjdev/libaums/UsbMassStorageDevice;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)[Lcom/github/mjdev/libaums/UsbMassStorageDevice;", "", "Landroid/hardware/usb/UsbDevice;", "libaums_release"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<UsbMassStorageDevice> getMassStorageDevices(@NotNull UsbDevice $this$getMassStorageDevices, @NotNull Context context) {
            Iterable $this$filterTo$iv$iv;
            Object object;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)$this$getMassStorageDevices, (String)"$this$getMassStorageDevices");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object2 = context.getSystemService("usb");
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.hardware.usb.UsbManager");
            }
            UsbManager usbManager = (UsbManager)object2;
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$getMassStorageDevices.getInterfaceCount());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                object = $this$getMassStorageDevices.getInterface((int)it);
                collection.add(object);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UsbInterface it = (UsbInterface)element$iv$iv;
                boolean bl = false;
                UsbInterface usbInterface = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)usbInterface, (String)"it");
                if (!(usbInterface.getInterfaceClass() == 8 && it.getInterfaceSubclass() == 6 && it.getInterfaceProtocol() == 80)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                UsbMassStorageDevice usbMassStorageDevice;
                void usbInterface;
                UsbInterface it = (UsbInterface)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Log.i((String)TAG, (String)("Found usb interface: " + usbInterface));
                void v2 = usbInterface;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"usbInterface");
                int endpointCount = v2.getEndpointCount();
                if (endpointCount != 2) {
                    Log.w((String)TAG, (String)"Interface endpoint count != 2");
                }
                UsbEndpoint outEndpoint = null;
                UsbEndpoint inEndpoint = null;
                int n = 0;
                int n2 = endpointCount;
                while (n < n2) {
                    void j;
                    UsbEndpoint endpoint = usbInterface.getEndpoint((int)j);
                    Log.i((String)TAG, (String)("Found usb endpoint: " + endpoint));
                    UsbEndpoint usbEndpoint = endpoint;
                    Intrinsics.checkExpressionValueIsNotNull((Object)usbEndpoint, (String)"endpoint");
                    if (usbEndpoint.getType() == 2) {
                        if (endpoint.getDirection() == 0) {
                            outEndpoint = endpoint;
                        } else {
                            inEndpoint = endpoint;
                        }
                    }
                    ++j;
                }
                if (outEndpoint == null || inEndpoint == null) {
                    Log.e((String)TAG, (String)("Not all needed endpoints found. In: " + (outEndpoint != null) + ", Out: " + (outEndpoint != null)));
                    usbMassStorageDevice = null;
                } else {
                    usbMassStorageDevice = new UsbMassStorageDevice(usbManager, $this$getMassStorageDevices, (UsbInterface)usbInterface, inEndpoint, outEndpoint, null);
                }
                object = usbMassStorageDevice;
                collection.add(object);
            }
            return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final UsbMassStorageDevice[] getMassStorageDevices(@NotNull Context context) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("usb");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.hardware.usb.UsbManager");
            }
            UsbManager usbManager = (UsbManager)object;
            HashMap hashMap = usbManager.getDeviceList();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"usbManager.deviceList");
            Map $this$map$iv = hashMap;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var8_8 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var8_8.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                UsbDevice device = (UsbDevice)it.getValue();
                Log.i((String)TAG, (String)("found usb device: " + it));
                UsbDevice usbDevice = device;
                Intrinsics.checkExpressionValueIsNotNull((Object)usbDevice, (String)"device");
                List<UsbMassStorageDevice> list = Companion.getMassStorageDevices(usbDevice, context);
                collection.add(list);
            }
            Collection $this$toTypedArray$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            boolean $i$f$toTypedArray = false;
            Collection collection = $this$toTypedArray$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            UsbMassStorageDevice[] usbMassStorageDeviceArray = thisCollection$iv.toArray(new UsbMassStorageDevice[0]);
            if (usbMassStorageDeviceArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return usbMassStorageDeviceArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

