/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition.mbr;

import android.util.Log;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import com.github.mjdev.libaums.partition.mbr.MasterBootRecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/github/mjdev/libaums/partition/mbr/MasterBootRecord;", "Lcom/github/mjdev/libaums/partition/PartitionTable;", "()V", "partitionTableEntries", "", "Lcom/github/mjdev/libaums/partition/PartitionTableEntry;", "getPartitionTableEntries", "()Ljava/util/List;", "partitions", "Ljava/util/ArrayList;", "size", "", "getSize", "()I", "Companion", "libaums_release"})
public final class MasterBootRecord
implements PartitionTable {
    private final ArrayList<PartitionTableEntry> partitions = new ArrayList();
    private static final Companion.partitionTypes.1 partitionTypes;
    private static final String TAG;
    private static final int TABLE_OFFSET = 446;
    private static final int TABLE_ENTRY_SIZE = 16;
    public static final Companion Companion;

    @Override
    public int getSize() {
        return 512;
    }

    @Override
    @NotNull
    public List<PartitionTableEntry> getPartitionTableEntries() {
        return this.partitions;
    }

    private MasterBootRecord() {
    }

    static {
        Companion = new Companion(null);
        partitionTypes = new HashMap<Integer, Integer>(){
            {
                this.put(11, 2);
                this.put(12, 2);
                this.put(27, 2);
                this.put(28, 2);
                this.put(1, 0);
                this.put(4, 1);
                this.put(6, 1);
                this.put(14, 1);
                this.put(131, 3);
                this.put(7, 6);
                this.put(175, 4);
            }
        };
        TAG = MasterBootRecord.class.getSimpleName();
    }

    public /* synthetic */ MasterBootRecord(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000/\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/github/mjdev/libaums/partition/mbr/MasterBootRecord$Companion;", "", "()V", "TABLE_ENTRY_SIZE", "", "TABLE_OFFSET", "TAG", "", "kotlin.jvm.PlatformType", "partitionTypes", "com/github/mjdev/libaums/partition/mbr/MasterBootRecord$Companion$partitionTypes$1", "Lcom/github/mjdev/libaums/partition/mbr/MasterBootRecord$Companion$partitionTypes$1;", "read", "Lcom/github/mjdev/libaums/partition/mbr/MasterBootRecord;", "buffer", "Ljava/nio/ByteBuffer;", "libaums_release"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final MasterBootRecord read(@NotNull ByteBuffer buffer) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            MasterBootRecord result = new MasterBootRecord(null);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            if (buffer.limit() < 512) {
                throw (Throwable)new IOException("Size mismatch!");
            }
            if (buffer.get(510) != (byte)85 || buffer.get(511) != (byte)170) {
                Log.i((String)TAG, (String)"not a valid mbr partition table!");
                return null;
            }
            int n = 0;
            int n2 = 3;
            while (n <= n2) {
                void i;
                int offset = 446 + i * 16;
                byte partitionType = buffer.get(offset + 4);
                if (partitionType != 0) {
                    if (partitionType == 5 || partitionType == 15) {
                        Log.w((String)TAG, (String)"extended partitions are currently unsupported!");
                    } else {
                        Integer type = (Integer)partitionTypes.get((Object)(partitionType & 0xFF));
                        if (type == null) {
                            Log.d((String)TAG, (String)("Unknown partition type" + partitionType));
                            type = -1;
                        }
                        PartitionTableEntry entry = new PartitionTableEntry(type, buffer.getInt(offset + 8), buffer.getInt(offset + 12));
                        result.partitions.add(entry);
                    }
                }
                ++i;
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

