/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.fs.FileSystemPartitionTableCreator;
import com.github.mjdev.libaums.partition.mbr.MasterBootRecordCreator;
import java.io.IOException;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/mjdev/libaums/partition/PartitionTableFactory;", "", "()V", "partitionTables", "Ljava/util/ArrayList;", "Lcom/github/mjdev/libaums/partition/PartitionTableFactory$PartitionTableCreator;", "createPartitionTable", "Lcom/github/mjdev/libaums/partition/PartitionTable;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "registerPartitionTable", "", "creator", "PartitionTableCreator", "UnsupportedPartitionTableException", "libaums_release"})
public final class PartitionTableFactory {
    private static final ArrayList<PartitionTableCreator> partitionTables;
    public static final PartitionTableFactory INSTANCE;

    @NotNull
    public final PartitionTable createPartitionTable(@NotNull BlockDeviceDriver blockDevice) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
        for (PartitionTableCreator creator : partitionTables) {
            PartitionTable table = creator.read(blockDevice);
            if (table == null) continue;
            return table;
        }
        throw (Throwable)new UnsupportedPartitionTableException();
    }

    public final synchronized void registerPartitionTable(@NotNull PartitionTableCreator creator) {
        Intrinsics.checkParameterIsNotNull((Object)creator, (String)"creator");
        partitionTables.add(creator);
    }

    private PartitionTableFactory() {
    }

    static {
        PartitionTableFactory partitionTableFactory;
        INSTANCE = partitionTableFactory = new PartitionTableFactory();
        partitionTables = new ArrayList();
        partitionTableFactory.registerPartitionTable(new FileSystemPartitionTableCreator());
        partitionTableFactory.registerPartitionTable(new MasterBootRecordCreator());
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/github/mjdev/libaums/partition/PartitionTableFactory$UnsupportedPartitionTableException;", "Ljava/io/IOException;", "()V", "libaums_release"})
    public static final class UnsupportedPartitionTableException
    extends IOException {
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/github/mjdev/libaums/partition/PartitionTableFactory$PartitionTableCreator;", "", "read", "Lcom/github/mjdev/libaums/partition/PartitionTable;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "libaums_release"})
    public static interface PartitionTableCreator {
        @Nullable
        public PartitionTable read(@NotNull BlockDeviceDriver var1) throws IOException;
    }
}

