/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

class ShortName {
    private static int SIZE = 11;
    private ByteBuffer data;

    ShortName(String name, String extension) {
        byte[] tmp = new byte[SIZE];
        Arrays.fill(tmp, (byte)32);
        int length = Math.min(name.length(), 8);
        System.arraycopy(name.getBytes(Charset.forName("ASCII")), 0, tmp, 0, length);
        System.arraycopy(extension.getBytes(Charset.forName("ASCII")), 0, tmp, 8, extension.length());
        if (tmp[0] == 229) {
            tmp[0] = 5;
        }
        this.data = ByteBuffer.wrap(tmp);
    }

    private ShortName(ByteBuffer data) {
        this.data = data;
    }

    static ShortName parse(ByteBuffer data) {
        byte[] tmp = new byte[SIZE];
        data.get(tmp);
        return new ShortName(ByteBuffer.wrap(tmp));
    }

    String getString() {
        int i;
        char[] name = new char[8];
        char[] extension = new char[3];
        for (i = 0; i < 8; ++i) {
            name[i] = (char)(this.data.get(i) & 0xFF);
        }
        if (this.data.get(0) == 5) {
            name[0] = 229;
        }
        for (i = 0; i < 3; ++i) {
            extension[i] = (char)(this.data.get(i + 8) & 0xFF);
        }
        String strName = new String(name).trim();
        String strExt = new String(extension).trim();
        return strExt.isEmpty() ? strName : strName + "." + strExt;
    }

    void serialize(ByteBuffer buffer) {
        buffer.put(this.data.array(), 0, SIZE);
    }

    byte calculateCheckSum() {
        int sum = 0;
        for (int i = 0; i < SIZE; ++i) {
            sum = (sum & true ? 128 : 0) + ((sum & 0xFF) >> 1) + this.data.get(i);
        }
        return (byte)(sum & 0xFF);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ShortName)) {
            return false;
        }
        return Arrays.equals(this.data.array(), ((ShortName)other).data.array());
    }

    public String toString() {
        return this.getString();
    }
}

