/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.scsi.commands;

import com.github.mjdev.libaums.driver.scsi.commands.CommandBlockWrapper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ScsiRead10
extends CommandBlockWrapper {
    private static final byte LENGTH = 10;
    private static final byte OPCODE = 40;
    private int blockAddress;
    private int transferBytes;
    private int blockSize;
    private short transferBlocks;

    public ScsiRead10() {
        super(0, CommandBlockWrapper.Direction.IN, (byte)0, (byte)10);
    }

    public ScsiRead10(int blockAddress, int transferBytes, int blockSize) {
        super(transferBytes, CommandBlockWrapper.Direction.IN, (byte)0, (byte)10);
        this.init(blockAddress, transferBytes, blockSize);
    }

    public void init(int blockAddress, int transferBytes, int blockSize) {
        this.dCbwDataTransferLength = transferBytes;
        this.blockAddress = blockAddress;
        this.transferBytes = transferBytes;
        this.blockSize = blockSize;
        short transferBlocks = (short)(transferBytes / blockSize);
        if (transferBytes % blockSize != 0) {
            throw new IllegalArgumentException("transfer bytes is not a multiple of block size");
        }
        this.transferBlocks = transferBlocks;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        super.serialize(buffer);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put((byte)40);
        buffer.put((byte)0);
        buffer.putInt(this.blockAddress);
        buffer.put((byte)0);
        buffer.putShort(this.transferBlocks);
    }

    public String toString() {
        return "ScsiRead10 [blockAddress=" + this.blockAddress + ", transferBytes=" + this.transferBytes + ", blockSize=" + this.blockSize + ", transferBlocks=" + this.transferBlocks + ", getdCbwDataTransferLength()=" + this.getdCbwDataTransferLength() + "]";
    }
}

