/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.scsi.commands;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class CommandBlockWrapper {
    private static final int D_CBW_SIGNATURE = 1128420181;
    private int dCbwTag;
    protected int dCbwDataTransferLength;
    private byte bmCbwFlags;
    private byte bCbwLun;
    private byte bCbwcbLength;
    private Direction direction;

    protected CommandBlockWrapper(int transferLength, Direction direction, byte lun, byte cbwcbLength) {
        this.dCbwDataTransferLength = transferLength;
        this.direction = direction;
        if (direction == Direction.IN) {
            this.bmCbwFlags = (byte)-128;
        }
        this.bCbwLun = lun;
        this.bCbwcbLength = cbwcbLength;
    }

    public void serialize(ByteBuffer buffer) {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(1128420181);
        buffer.putInt(this.dCbwTag);
        buffer.putInt(this.dCbwDataTransferLength);
        buffer.put(this.bmCbwFlags);
        buffer.put(this.bCbwLun);
        buffer.put(this.bCbwcbLength);
    }

    public int getdCbwTag() {
        return this.dCbwTag;
    }

    public void setdCbwTag(int dCbwTag) {
        this.dCbwTag = dCbwTag;
    }

    public int getdCbwDataTransferLength() {
        return this.dCbwDataTransferLength;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static enum Direction {
        IN,
        OUT,
        NONE;

    }
}

