/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.storageprovider;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.provider.DocumentsProvider;
import android.util.Log;
import android.util.LruCache;
import android.webkit.MimeTypeMap;
import com.github.mjdev.libaums.UsbMassStorageDevice;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.UsbFileInputStream;
import com.github.mjdev.libaums.fs.UsbFileOutputStream;
import com.github.mjdev.libaums.partition.Partition;
import com.github.mjdev.libaums.storageprovider.R;
import com.github.mjdev.libaums.storageprovider.util.ParcelFileDescriptorUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@TargetApi(value=19)
public class UsbDocumentProvider
extends DocumentsProvider {
    private static final String TAG = UsbDocumentProvider.class.getSimpleName();
    private static final String DOCUMENTS_AUTHORITY = "com.github.mjdev.libaums.storageprovider.documents";
    private static final String ACTION_USB_PERMISSION = "com.github.mjdev.libaums.storageprovider.USB_PERMISSION";
    private static final String DIRECTORY_SEPERATOR = "/";
    private static final String ROOT_SEPERATOR = ":";
    private static final String[] DEFAULT_ROOT_PROJECTION = new String[]{"root_id", "summary", "flags", "title", "document_id", "icon", "available_bytes"};
    private static final String[] DEFAULT_DOCUMENT_PROJECTION = new String[]{"document_id", "_display_name", "flags", "mime_type", "_size", "last_modified"};
    private final Map<String, UsbPartition> mRoots = new HashMap<String, UsbPartition>();
    private final LruCache<String, UsbFile> mFileCache = new LruCache(100);

    private static String[] resolveRootProjection(String[] projection) {
        return projection != null ? projection : DEFAULT_ROOT_PROJECTION;
    }

    private static String[] resolveDocumentProjection(String[] projection) {
        return projection != null ? projection : DEFAULT_DOCUMENT_PROJECTION;
    }

    public Cursor queryRoots(String[] projection) throws FileNotFoundException {
        Log.d((String)TAG, (String)"queryRoots()");
        MatrixCursor result = new MatrixCursor(UsbDocumentProvider.resolveRootProjection(projection));
        for (Map.Entry<String, UsbPartition> root : this.mRoots.entrySet()) {
            String title;
            UsbPartition usbPartition = root.getValue();
            FileSystem fileSystem = usbPartition.fileSystem;
            UsbFile rootDirectory = fileSystem.getRootDirectory();
            String volumeLabel = fileSystem.getVolumeLabel();
            if (Build.VERSION.SDK_INT >= 21) {
                UsbDevice usbDevice = usbPartition.device;
                title = usbDevice.getManufacturerName() + " " + usbDevice.getProductName();
            } else {
                title = this.getContext().getString(R.string.storage_root);
            }
            String documentId = this.getDocIdForFile(rootDirectory);
            Log.d((String)TAG, (String)("add root " + documentId));
            MatrixCursor.RowBuilder row = result.newRow();
            row.add("root_id", (Object)root.getKey());
            row.add("document_id", (Object)documentId);
            row.add("title", (Object)title);
            row.add("flags", (Object)19);
            row.add("icon", (Object)R.drawable.ic_usb_black_24dp);
            row.add("summary", (Object)volumeLabel);
            row.add("available_bytes", (Object)fileSystem.getFreeSpace());
        }
        return result;
    }

    public Cursor queryDocument(String documentId, String[] projection) throws FileNotFoundException {
        Log.d((String)TAG, (String)("queryDocument() " + documentId));
        try {
            MatrixCursor result = new MatrixCursor(UsbDocumentProvider.resolveDocumentProjection(projection));
            this.includeFile(result, this.getFileForDocId(documentId));
            return result;
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public Cursor queryChildDocuments(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        Log.d((String)TAG, (String)("queryChildDocuments() " + parentDocumentId));
        try {
            MatrixCursor result = new MatrixCursor(UsbDocumentProvider.resolveDocumentProjection(projection));
            UsbFile parent = this.getFileForDocId(parentDocumentId);
            for (UsbFile child : parent.listFiles()) {
                this.includeFile(result, child);
            }
            return result;
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public ParcelFileDescriptor openDocument(String documentId, String mode, CancellationSignal signal) throws FileNotFoundException {
        Log.d((String)TAG, (String)("openDocument() " + documentId));
        try {
            UsbFile file = this.getFileForDocId(documentId);
            int accessMode = ParcelFileDescriptor.parseMode((String)mode);
            if ((accessMode | 0x10000000) == 0x10000000) {
                Log.d((String)TAG, (String)"openDocument() piping to UsbFileInputStream");
                return ParcelFileDescriptorUtil.pipeFrom((InputStream)new UsbFileInputStream(file));
            }
            if ((accessMode | 0x20000000) == 0x20000000) {
                Log.d((String)TAG, (String)"openDocument() piping to UsbFileOutputStream");
                return ParcelFileDescriptorUtil.pipeTo((OutputStream)new UsbFileOutputStream(file));
            }
            Log.d((String)TAG, (String)"openDocument() return null");
            return null;
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public boolean isChildDocument(String parentDocumentId, String documentId) {
        return documentId.startsWith(parentDocumentId);
    }

    public String createDocument(String parentDocumentId, String mimeType, String displayName) throws FileNotFoundException {
        Log.d((String)TAG, (String)("createDocument() " + parentDocumentId));
        try {
            UsbFile parent = this.getFileForDocId(parentDocumentId);
            UsbFile child = "vnd.android.document/directory".equals(mimeType) ? parent.createDirectory(displayName) : parent.createFile(UsbDocumentProvider.getFileName(mimeType, displayName));
            return this.getDocIdForFile(child);
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public String renameDocument(String documentId, String displayName) throws FileNotFoundException {
        Log.d((String)TAG, (String)("renameDocument() " + documentId));
        try {
            UsbFile file = this.getFileForDocId(documentId);
            file.setName(UsbDocumentProvider.getFileName(UsbDocumentProvider.getMimeType(file), displayName));
            this.mFileCache.remove((Object)documentId);
            return this.getDocIdForFile(file);
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public void deleteDocument(String documentId) throws FileNotFoundException {
        Log.d((String)TAG, (String)("deleteDocument() " + documentId));
        try {
            UsbFile file = this.getFileForDocId(documentId);
            file.delete();
            this.mFileCache.remove((Object)documentId);
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public String getDocumentType(String documentId) {
        Log.d((String)TAG, (String)("getDocumentType() " + documentId));
        try {
            return UsbDocumentProvider.getMimeType(this.getFileForDocId(documentId));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
            return "application/octet-stream";
        }
    }

    public boolean onCreate() {
        Log.d((String)TAG, (String)"onCreate()");
        Context context = this.getContext();
        assert (context != null);
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                if (intent.getBooleanExtra("permission", false)) {
                    UsbDocumentProvider.this.discoverDevice(device);
                }
            }
        }, new IntentFilter(ACTION_USB_PERMISSION));
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                UsbDocumentProvider.this.discoverDevice(device);
            }
        }, new IntentFilter("android.hardware.usb.action.USB_DEVICE_ATTACHED"));
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                UsbDocumentProvider.this.detachDevice(device);
            }
        }, new IntentFilter("android.hardware.usb.action.USB_DEVICE_DETACHED"));
        UsbManager usbManager = (UsbManager)context.getSystemService("usb");
        for (UsbDevice device : usbManager.getDeviceList().values()) {
            this.discoverDevice(device);
        }
        return true;
    }

    private static String getMimeType(UsbFile file) {
        if (file.isDirectory()) {
            return "vnd.android.document/directory";
        }
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)file.getName()).toLowerCase();
        if (extension != null) {
            String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
            Log.d((String)TAG, (String)("mimeType: " + mimeType));
            return mimeType;
        }
        return "application/octet-stream";
    }

    private static String getFileName(String mimeType, String displayName) {
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)displayName).toLowerCase();
        if (!(extension != null && Objects.equals(mimeType, MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension)) || (extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType)) == null)) {
            displayName = displayName + "." + extension;
        }
        return displayName;
    }

    private void includeFile(MatrixCursor result, UsbFile file) throws FileNotFoundException {
        MatrixCursor.RowBuilder row = result.newRow();
        row.add("document_id", (Object)this.getDocIdForFile(file));
        row.add("_display_name", (Object)(file.isRoot() ? "" : file.getName()));
        row.add("mime_type", (Object)UsbDocumentProvider.getMimeType(file));
        int flags = 70;
        if (file.isDirectory()) {
            flags |= 8;
        }
        row.add("flags", (Object)flags);
        row.add("_size", (Object)(file.isDirectory() ? 0L : file.getLength()));
        row.add("last_modified", (Object)(file.isRoot() ? 0L : file.lastModified()));
    }

    private void discoverDevice(UsbDevice device) {
        Log.d((String)TAG, (String)("discoverDevice() " + device.toString()));
        Context context = this.getContext();
        assert (context != null);
        UsbManager usbManager = (UsbManager)context.getSystemService("usb");
        for (UsbMassStorageDevice massStorageDevice : UsbMassStorageDevice.getMassStorageDevices((Context)this.getContext())) {
            if (!device.equals((Object)massStorageDevice.getUsbDevice())) continue;
            if (usbManager.hasPermission(device)) {
                this.addRoot(massStorageDevice);
                continue;
            }
            PendingIntent permissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            usbManager.requestPermission(device, permissionIntent);
        }
    }

    private void detachDevice(UsbDevice usbDevice) {
        Log.d((String)TAG, (String)("detachDevice() " + usbDevice.toString()));
        for (Map.Entry<String, UsbPartition> root : this.mRoots.entrySet()) {
            if (!root.getValue().device.equals((Object)usbDevice)) continue;
            Log.d((String)TAG, (String)("remove rootId " + root.getKey()));
            this.mRoots.remove(root.getKey());
            this.mFileCache.evictAll();
            this.notifyRootsChanged();
            break;
        }
    }

    private void addRoot(UsbMassStorageDevice device) {
        Log.d((String)TAG, (String)("addRoot() " + device.toString()));
        try {
            device.init();
            for (Partition partition : device.getPartitions()) {
                UsbPartition usbPartition = new UsbPartition();
                usbPartition.device = device.getUsbDevice();
                usbPartition.fileSystem = partition.getFileSystem();
                this.mRoots.put(Integer.toString(partition.hashCode()), usbPartition);
                Log.d((String)TAG, (String)("found root " + partition.hashCode()));
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"error setting up device", (Throwable)e);
        }
        this.notifyRootsChanged();
    }

    private void notifyRootsChanged() {
        this.getContext().getContentResolver().notifyChange(DocumentsContract.buildRootsUri((String)DOCUMENTS_AUTHORITY), null, false);
    }

    private String getDocIdForFile(UsbFile file) throws FileNotFoundException {
        if (file.isRoot()) {
            for (Map.Entry<String, UsbPartition> root : this.mRoots.entrySet()) {
                if (!file.equals(root.getValue().fileSystem.getRootDirectory())) continue;
                String documentId = root.getKey() + ROOT_SEPERATOR;
                this.mFileCache.put((Object)documentId, (Object)file);
                return documentId;
            }
            throw new FileNotFoundException("Missing root entry");
        }
        String documentId = this.getDocIdForFile(file.getParent()) + DIRECTORY_SEPERATOR + file.getName();
        this.mFileCache.put((Object)documentId, (Object)file);
        return documentId;
    }

    private UsbFile getFileForDocId(String documentId) throws IOException {
        Log.d((String)TAG, (String)("getFileForDocId() " + documentId));
        UsbFile file = (UsbFile)this.mFileCache.get((Object)documentId);
        if (null != file) {
            return file;
        }
        Log.d((String)TAG, (String)("No cache entry for " + documentId));
        int splitIndex = documentId.lastIndexOf(DIRECTORY_SEPERATOR);
        if (splitIndex < 0) {
            String rootId = documentId.substring(0, documentId.length() - 1);
            UsbPartition usbPartition = this.mRoots.get(rootId);
            if (null == usbPartition) {
                throw new FileNotFoundException("Missing root for " + rootId);
            }
            file = usbPartition.fileSystem.getRootDirectory();
            this.mFileCache.put((Object)documentId, (Object)file);
            return file;
        }
        UsbFile parent = this.getFileForDocId(documentId.substring(0, splitIndex));
        if (null == parent) {
            throw new FileNotFoundException("Missing parent for " + documentId);
        }
        String name = documentId.substring(splitIndex + 1);
        for (UsbFile child : parent.listFiles()) {
            if (!name.equals(child.getName())) continue;
            this.mFileCache.put((Object)documentId, (Object)child);
            return child;
        }
        throw new FileNotFoundException("File not found " + documentId);
    }

    private class UsbPartition {
        UsbDevice device;
        FileSystem fileSystem;

        private UsbPartition() {
        }
    }
}

