/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizool.technology.tableaccess.business;

import com.github.mizool.technology.tableaccess.business.Column;
import lombok.NonNull;

public final class Cell {
    @NonNull
    private final Column column;
    private final Object value;

    Cell(@NonNull Column column, Object value) {
        if (column == null) {
            throw new NullPointerException("column");
        }
        this.column = column;
        this.value = value;
    }

    public static CellBuilder builder() {
        return new CellBuilder();
    }

    public CellBuilder toBuilder() {
        return new CellBuilder().column(this.column).value(this.value);
    }

    @NonNull
    public Column getColumn() {
        return this.column;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)o;
        Column this$column = this.getColumn();
        Column other$column = other.getColumn();
        if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Column $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Cell(column=" + this.getColumn() + ", value=" + this.getValue() + ")";
    }

    public static class CellBuilder {
        private Column column;
        private Object value;

        CellBuilder() {
        }

        public CellBuilder column(Column column) {
            this.column = column;
            return this;
        }

        public CellBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public Cell build() {
            return new Cell(this.column, this.value);
        }

        public String toString() {
            return "Cell.CellBuilder(column=" + this.column + ", value=" + this.value + ")";
        }
    }
}

