/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.influxdb;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.springframework.data.influxdb.InfluxDBAccessor;
import org.springframework.data.influxdb.InfluxDBConnectionFactory;
import org.springframework.data.influxdb.InfluxDBOperations;
import org.springframework.data.influxdb.converter.PointCollectionConverter;
import org.springframework.util.Assert;

public class InfluxDBTemplate<T>
extends InfluxDBAccessor
implements InfluxDBOperations<T> {
    private PointCollectionConverter<T> converter;

    public InfluxDBTemplate() {
    }

    public InfluxDBTemplate(InfluxDBConnectionFactory connectionFactory, PointCollectionConverter<T> converter) {
        this.setConnectionFactory(connectionFactory);
        this.setConverter(converter);
    }

    public void setConverter(PointCollectionConverter<T> converter) {
        this.converter = converter;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull(this.converter, (String)"PointCollectionConverter is required");
    }

    @Override
    public void createDatabase() {
        String database = this.getDatabase();
        this.getConnection().createDatabase(database);
    }

    @Override
    public void write(T payload) {
        Preconditions.checkArgument((payload != null ? 1 : 0) != 0, (Object)"Parameter 'payload' must not be null");
        String database = this.getDatabase();
        String retentionPolicy = this.getRetentionPolicy();
        BatchPoints ops = BatchPoints.database((String)database).retentionPolicy(retentionPolicy).consistency(InfluxDB.ConsistencyLevel.ALL).build();
        ((List)this.converter.convert(payload)).forEach(arg_0 -> ((BatchPoints)ops).point(arg_0));
        this.getConnection().write(ops);
    }

    @Override
    public void write(List<T> payload) {
        Preconditions.checkArgument((payload != null ? 1 : 0) != 0, (Object)"Parameter 'payload' must not be null");
        String database = this.getDatabase();
        String retentionPolicy = this.getConnectionFactory().getProperties().getRetentionPolicy();
        BatchPoints ops = BatchPoints.database((String)database).retentionPolicy(retentionPolicy).consistency(InfluxDB.ConsistencyLevel.ALL).build();
        payload.forEach(t -> ((List)this.converter.convert(t)).forEach(arg_0 -> ((BatchPoints)ops).point(arg_0)));
        this.getConnection().write(ops);
    }

    @Override
    public QueryResult query(Query query) {
        return this.getConnection().query(query);
    }

    @Override
    public QueryResult query(Query query, TimeUnit timeUnit) {
        return this.getConnection().query(query, timeUnit);
    }

    @Override
    public Pong ping() {
        return this.getConnection().ping();
    }

    @Override
    public String version() {
        return this.getConnection().version();
    }
}

