/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.connect;

import org.springframework.social.oauth2.AbstractOAuth2ServiceProvider;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.salesforce.api.Salesforce;
import org.springframework.social.salesforce.api.impl.SalesforceTemplate;
import org.springframework.social.salesforce.connect.SalesforceOAuth2Template;

public class SalesforceServiceProvider
extends AbstractOAuth2ServiceProvider<Salesforce> {
    public SalesforceServiceProvider(String clientId, String clientSecret) {
        this(clientId, clientSecret, "https://login.salesforce.com/services/oauth2/authorize", "https://login.salesforce.com/services/oauth2/token");
    }

    public SalesforceServiceProvider(String clientId, String clientSecret, String authorizeUrl, String tokenUrl) {
        super((OAuth2Operations)new SalesforceOAuth2Template(clientId, clientSecret, authorizeUrl, tokenUrl));
    }

    public Salesforce getApi(String accessToken) {
        SalesforceTemplate template = new SalesforceTemplate(accessToken);
        String instanceUrl = ((SalesforceOAuth2Template)this.getOAuthOperations()).getInstanceUrl();
        if (instanceUrl != null) {
            template.setInstanceUrl(instanceUrl);
        }
        return template;
    }
}

