/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.connect;

import java.io.IOException;
import java.util.Collections;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.OAuth2Template;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SalesforceOAuth2Template
extends OAuth2Template {
    private String instanceUrl = null;

    public SalesforceOAuth2Template(String clientId, String clientSecret, String authorizeUrl, String accessTokenUrl) {
        super(clientId, clientSecret, authorizeUrl, accessTokenUrl);
    }

    public SalesforceOAuth2Template(String clientId, String clientSecret, String authorizeUrl, String authenticateUrl, String accessTokenUrl) {
        super(clientId, clientSecret, authorizeUrl, authenticateUrl, accessTokenUrl);
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    protected RestTemplate createRestTemplate() {
        RestTemplate restTemplate = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        FormHttpMessageConverter messageConverter = new FormHttpMessageConverter(){

            public boolean canRead(Class<?> clazz, MediaType mediaType) {
                return true;
            }

            public MultiValueMap<String, String> read(Class<? extends MultiValueMap<String, ?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
                if (inputMessage.getHeaders().getContentType() == null) {
                    inputMessage.getHeaders().setContentType(MediaType.TEXT_PLAIN);
                }
                return super.read(clazz, inputMessage);
            }
        };
        restTemplate.setMessageConverters(Collections.singletonList(messageConverter));
        return restTemplate;
    }

    protected AccessGrant postForAccessGrant(String accessTokenUrl, MultiValueMap<String, String> parameters) {
        MultiValueMap result = (MultiValueMap)this.getRestTemplate().postForObject(accessTokenUrl, parameters, MultiValueMap.class, new Object[0]);
        this.instanceUrl = (String)result.getFirst((Object)"instance_url");
        return this.createAccessGrant((String)result.getFirst((Object)"access_token"), (String)result.getFirst((Object)"scope"), (String)result.getFirst((Object)"refresh_token"), null, null);
    }
}

