/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.InvalidAuthorizationException;
import org.springframework.social.OperationNotPermittedException;
import org.springframework.social.RateLimitExceededException;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class ErrorHandler
extends DefaultResponseErrorHandler {
    public void handleError(ClientHttpResponse response) throws IOException {
        if (response.getStatusCode().equals((Object)HttpStatus.BAD_REQUEST)) {
            Map<String, String> error = this.extractErrorDetailsFromResponse(response);
            if ("unsupported_response_type".equals(error.get("error"))) {
                throw new OperationNotPermittedException("salesforce", error.get("error_description"));
            }
            if ("invalid_client_id".equals(error.get("error"))) {
                throw new InvalidAuthorizationException("salesforce", error.get("error_description"));
            }
            if ("invalid_request".equals(error.get("error"))) {
                throw new OperationNotPermittedException("salesforce", error.get("error_description"));
            }
            if ("invalid_client_credentials".equals(error.get("error"))) {
                throw new InvalidAuthorizationException("salesforce", error.get("error_description"));
            }
            if ("invalid_grant".equals(error.get("error"))) {
                if ("invalid user credentials".equals(error.get("error_description"))) {
                    throw new InvalidAuthorizationException("salesforce", error.get("error_description"));
                }
                if ("IP restricted or invalid login hours".equals(error.get("error_description"))) {
                    throw new OperationNotPermittedException("salesforce", error.get("error_description"));
                }
                throw new InvalidAuthorizationException("salesforce", error.get("error_description"));
            }
            if ("inactive_user".equals(error.get("error"))) {
                throw new OperationNotPermittedException("salesforce", error.get("error_description"));
            }
            if ("inactive_org".equals(error.get("error"))) {
                throw new OperationNotPermittedException("salesforce", error.get("error_description"));
            }
            if ("rate_limit_exceeded".equals(error.get("error"))) {
                throw new RateLimitExceededException("salesforce");
            }
            if ("invalid_scope".equals(error.get("error"))) {
                throw new InvalidAuthorizationException("salesforce", error.get("error_description"));
            }
        }
        super.handleError(response);
    }

    private Map<String, String> extractErrorDetailsFromResponse(ClientHttpResponse response) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        try {
            return (Map)mapper.readValue(response.getBody(), Map.class);
        }
        catch (JsonParseException e) {
            return null;
        }
    }
}

