/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.client;

import java.util.Map;
import org.springframework.social.salesforce.api.Salesforce;
import org.springframework.social.salesforce.api.impl.SalesforceTemplate;
import org.springframework.social.salesforce.client.ErrorHandler;
import org.springframework.social.salesforce.client.SalesforceFactory;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class BaseSalesforceFactory
implements SalesforceFactory {
    private static final String DEFAULT_AUTH_URL = "https://login.salesforce.com/services/oauth2/token";
    private String clientId;
    private String clientSecret;
    private String authorizeUrl = "https://login.salesforce.com/services/oauth2/token";
    private RestTemplate restTemplate;

    public BaseSalesforceFactory(String clientId, String clientSecret) {
        this(clientId, clientSecret, BaseSalesforceFactory.createRestTemplate());
    }

    public BaseSalesforceFactory(String clientId, String clientSecret, RestTemplate restTemplate) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.restTemplate = restTemplate;
    }

    public void setAuthorizeUrl(String authorizeUrl) {
        this.authorizeUrl = authorizeUrl;
    }

    public String getAuthorizeUrl() {
        return this.authorizeUrl == null ? DEFAULT_AUTH_URL : this.authorizeUrl;
    }

    @Override
    public Salesforce create(String username, String password, String securityToken) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"password");
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"username", (Object)username);
        map.add((Object)"password", (Object)(password + (securityToken == null ? "" : securityToken)));
        Map token = (Map)this.restTemplate.postForObject(this.authorizeUrl, (Object)map, Map.class, new Object[0]);
        SalesforceTemplate template = new SalesforceTemplate((String)token.get("access_token"), (String)token.get("id"));
        String instanceUrl = (String)token.get("instance_url");
        if (instanceUrl != null) {
            template.setInstanceUrl(instanceUrl);
        }
        return template;
    }

    private static RestTemplate createRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(ClientHttpRequestFactorySelector.getRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new ErrorHandler());
        return restTemplate;
    }
}

