/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.List;
import org.springframework.social.salesforce.api.ResultItem;
import org.springframework.social.salesforce.api.Salesforce;
import org.springframework.social.salesforce.api.SearchOperations;
import org.springframework.social.salesforce.api.impl.AbstractSalesForceOperations;
import org.springframework.social.support.URIBuilder;
import org.springframework.web.client.RestTemplate;

public class SearchTemplate
extends AbstractSalesForceOperations<Salesforce>
implements SearchOperations {
    private RestTemplate restTemplate;

    public SearchTemplate(Salesforce api, RestTemplate restTemplate) {
        super(api);
        this.restTemplate = restTemplate;
    }

    @Override
    public List<ResultItem> search(String soslQuery) {
        this.requireAuthorization();
        URI uri = URIBuilder.fromUri((String)(((Salesforce)this.api).getBaseUrl() + "/" + "v26.0" + "/search")).queryParam("q", soslQuery).build();
        JsonNode arr = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        return ((Salesforce)this.api).readList(arr, ResultItem.class);
    }
}

