/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.api.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.social.oauth2.AbstractOAuth2ApiBinding;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.social.salesforce.api.ApiOperations;
import org.springframework.social.salesforce.api.BulkApiOperations;
import org.springframework.social.salesforce.api.ChatterOperations;
import org.springframework.social.salesforce.api.QueryOperations;
import org.springframework.social.salesforce.api.RecentOperations;
import org.springframework.social.salesforce.api.SObjectOperations;
import org.springframework.social.salesforce.api.Salesforce;
import org.springframework.social.salesforce.api.SearchOperations;
import org.springframework.social.salesforce.api.impl.ApiTemplate;
import org.springframework.social.salesforce.api.impl.BulkApiTemplate;
import org.springframework.social.salesforce.api.impl.ChatterTemplate;
import org.springframework.social.salesforce.api.impl.QueryTemplate;
import org.springframework.social.salesforce.api.impl.RecentTemplate;
import org.springframework.social.salesforce.api.impl.SObjectsTemplate;
import org.springframework.social.salesforce.api.impl.SalesforceErrorHandler;
import org.springframework.social.salesforce.api.impl.SearchTemplate;
import org.springframework.social.salesforce.api.impl.json.SalesforceModule;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class SalesforceTemplate
extends AbstractOAuth2ApiBinding
implements Salesforce {
    private final Logger logger = LoggerFactory.getLogger(SalesforceTemplate.class);
    private static final String INSTANCE_URL = "https://na1.salesforce.com";
    private String instanceUrl;
    private String identityServiceUrl;
    private ObjectMapper objectMapper;
    private ApiOperations apiOperations;
    private BulkApiOperations bulkApiOperations;
    private ChatterOperations chatterOperations;
    private QueryOperations queryOperations;
    private RecentOperations recentOperations;
    private SearchOperations searchOperations;
    private SObjectOperations sObjectsOperations;

    public SalesforceTemplate() {
        this.initialize(null);
    }

    public SalesforceTemplate(String accessToken) {
        this(accessToken, null);
    }

    public SalesforceTemplate(String accessToken, String idUrl) {
        super(accessToken);
        this.identityServiceUrl = idUrl;
        this.initialize(accessToken);
        this.logger.debug("ACCESS TOKEN: {}", (Object)accessToken);
    }

    protected OAuth2Version getOAuth2Version() {
        return OAuth2Version.DRAFT_10;
    }

    @Override
    public ApiOperations apiOperations() {
        return this.apiOperations;
    }

    @Override
    public BulkApiOperations bulkApiOperations() {
        return this.bulkApiOperations;
    }

    @Override
    public ChatterOperations chatterOperations() {
        return this.chatterOperations;
    }

    @Override
    public QueryOperations queryOperations() {
        return this.queryOperations;
    }

    @Override
    public RecentOperations recentOperations() {
        return this.recentOperations;
    }

    @Override
    public SearchOperations searchOperations() {
        return this.searchOperations;
    }

    @Override
    public SObjectOperations sObjectsOperations() {
        return this.sObjectsOperations;
    }

    private void initialize(String accessToken) {
        this.apiOperations = new ApiTemplate(this, this.getRestTemplate());
        this.chatterOperations = new ChatterTemplate(this, this.getRestTemplate());
        this.queryOperations = new QueryTemplate(this, this.getRestTemplate());
        this.recentOperations = new RecentTemplate(this, this.getRestTemplate());
        this.searchOperations = new SearchTemplate(this, this.getRestTemplate());
        this.sObjectsOperations = new SObjectsTemplate(this, this.getRestTemplate());
        if (this.identityServiceUrl != null) {
            this.bulkApiOperations = new BulkApiTemplate(this, this.getRestTemplate(), accessToken);
        }
    }

    protected MappingJackson2HttpMessageConverter getJsonMessageConverter() {
        MappingJackson2HttpMessageConverter converter = super.getJsonMessageConverter();
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new SalesforceModule());
        converter.setObjectMapper(this.objectMapper);
        return converter;
    }

    protected void configureRestTemplate(RestTemplate restTemplate) {
        restTemplate.setErrorHandler((ResponseErrorHandler)new SalesforceErrorHandler());
    }

    @Override
    public <T> List<T> readList(JsonNode jsonNode, Class<T> type) {
        Object t = type == Map.class ? MapType.construct(type, (JavaType)SimpleType.construct(Object.class), (JavaType)SimpleType.construct(Object.class)) : SimpleType.construct(type);
        return (List)this.objectMapper.convertValue((Object)jsonNode, (JavaType)CollectionType.construct(List.class, (JavaType)t));
    }

    @Override
    public <T> T readObject(JsonNode jsonNode, Class<T> type) {
        return (T)this.objectMapper.convertValue((Object)jsonNode, type);
    }

    @Override
    public String getBaseUrl() {
        return (this.instanceUrl == null ? INSTANCE_URL : this.instanceUrl) + "/services/data";
    }

    @Override
    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    public void setIdentityServiceUrl(String idUrl) {
        this.identityServiceUrl = idUrl;
    }

    @Override
    public String getIdentityServiceUrl() {
        return this.identityServiceUrl;
    }
}

