/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.api.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.InsufficientPermissionException;
import org.springframework.social.InternalServerErrorException;
import org.springframework.social.InvalidAuthorizationException;
import org.springframework.social.RateLimitExceededException;
import org.springframework.social.ResourceNotFoundException;
import org.springframework.social.UncategorizedApiException;
import org.springframework.social.salesforce.api.SalesforceRequestException;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class SalesforceErrorHandler
extends DefaultResponseErrorHandler {
    Logger logger = LoggerFactory.getLogger(SalesforceErrorHandler.class);

    public void handleError(ClientHttpResponse response) throws IOException {
        Map<String, Object> errorDetails = this.extractErrorDetailsFromResponse(response);
        if (errorDetails == null) {
            this.handleUncategorizedError(response, errorDetails);
        }
        this.handleSalesforceError(response.getStatusCode(), errorDetails);
        this.handleUncategorizedError(response, errorDetails);
    }

    private void handleSalesforceError(HttpStatus statusCode, Map<String, Object> errorDetails) {
        if (statusCode.equals((Object)HttpStatus.NOT_FOUND)) {
            throw new ResourceNotFoundException("salesforce", this.extractErrorMessage(errorDetails));
        }
        if (statusCode.equals((Object)HttpStatus.SERVICE_UNAVAILABLE)) {
            throw new RateLimitExceededException("salesforce");
        }
        if (statusCode.equals((Object)HttpStatus.INTERNAL_SERVER_ERROR)) {
            throw new InternalServerErrorException("salesforce", errorDetails == null ? "Contact Salesforce administrator." : this.extractErrorMessage(errorDetails));
        }
        if (statusCode.equals((Object)HttpStatus.BAD_REQUEST) || statusCode.equals((Object)HttpStatus.MULTIPLE_CHOICES)) {
            throw new SalesforceRequestException(errorDetails);
        }
        if (statusCode.equals((Object)HttpStatus.UNAUTHORIZED)) {
            throw new InvalidAuthorizationException("salesforce", this.extractErrorMessage(errorDetails));
        }
        if (statusCode.equals((Object)HttpStatus.FORBIDDEN)) {
            throw new InsufficientPermissionException(this.extractErrorMessage(errorDetails));
        }
    }

    private void handleUncategorizedError(ClientHttpResponse response, Map<String, Object> errorDetails) {
        try {
            super.handleError(response);
        }
        catch (Exception e) {
            if (errorDetails == null) {
                throw new UncategorizedApiException("salesforce", "No error details from Salesforce.", (Throwable)e);
            }
            throw new UncategorizedApiException("salesforce", this.extractErrorMessage(errorDetails), (Throwable)e);
        }
    }

    private Map<String, Object> extractErrorDetailsFromResponse(ClientHttpResponse response) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        try {
            CollectionType listType = TypeFactory.defaultInstance().constructCollectionType(List.class, Map.class);
            List errorList = (List)mapper.readValue(response.getBody(), (JavaType)listType);
            if (errorList.size() > 0) {
                return (Map)errorList.get(0);
            }
        }
        catch (JsonParseException e) {
            this.logger.error("Unable to parse salesforce response: {} ", (Object)response);
            throw new UncategorizedApiException("salesforce", "Unable to read salesforce response.", (Throwable)e);
        }
        return null;
    }

    private String extractErrorMessage(Map<String, Object> errorDetails) {
        return (String)errorDetails.get("message");
    }
}

