/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.salesforce.api.SObjectDetail;
import org.springframework.social.salesforce.api.SObjectOperations;
import org.springframework.social.salesforce.api.SObjectSummary;
import org.springframework.social.salesforce.api.Salesforce;
import org.springframework.social.salesforce.api.impl.AbstractSalesForceOperations;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public class SObjectsTemplate
extends AbstractSalesForceOperations<Salesforce>
implements SObjectOperations {
    private RestTemplate restTemplate;

    public SObjectsTemplate(Salesforce api, RestTemplate restTemplate) {
        super(api);
        this.restTemplate = restTemplate;
    }

    @Override
    public List<Map> getSObjects() {
        this.requireAuthorization();
        JsonNode dataNode = (JsonNode)this.restTemplate.getForObject(((Salesforce)this.api).getBaseUrl() + "/{version}/sobjects", JsonNode.class, new Object[]{"v26.0"});
        return ((Salesforce)this.api).readList(dataNode.get("sobjects"), Map.class);
    }

    @Override
    public SObjectSummary getSObjectSummary(String name) {
        this.requireAuthorization();
        JsonNode node = (JsonNode)this.restTemplate.getForObject(((Salesforce)this.api).getBaseUrl() + "/{version}/sobjects/{name}", JsonNode.class, new Object[]{"v26.0", name});
        return ((Salesforce)this.api).readObject(node.get("objectDescribe"), SObjectSummary.class);
    }

    @Override
    public SObjectDetail describeSObject(String name) {
        this.requireAuthorization();
        return (SObjectDetail)this.restTemplate.getForObject(((Salesforce)this.api).getBaseUrl() + "/{version}/sobjects/{name}/describe", SObjectDetail.class, new Object[]{"v26.0", name});
    }

    @Override
    public Map getRow(String name, String id, String ... fields) {
        this.requireAuthorization();
        URIBuilder builder = URIBuilder.fromUri((String)(((Salesforce)this.api).getBaseUrl() + "/" + "v26.0" + "/sobjects/" + name + "/" + id));
        if (fields.length > 0) {
            builder.queryParam("fields", StringUtils.arrayToCommaDelimitedString((Object[])fields));
        }
        return (Map)this.restTemplate.getForObject(builder.build(), Map.class);
    }

    @Override
    public InputStream getBlob(String name, String id, String field) {
        this.requireAuthorization();
        return (InputStream)this.restTemplate.execute(((Salesforce)this.api).getBaseUrl() + "/{version}/sobjects/{name}/{id}/{field}", HttpMethod.GET, null, (ResponseExtractor)new ResponseExtractor<InputStream>(){

            public InputStream extractData(ClientHttpResponse response) throws IOException {
                return response.getBody();
            }
        }, new Object[]{"v26.0", name, id, field});
    }

    public Map<String, Object> create(String name, Map<String, Object> fields) {
        this.requireAuthorization();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(fields, (MultiValueMap)headers);
        return (Map)this.restTemplate.postForObject(((Salesforce)this.api).getBaseUrl() + "/{version}/sobjects/{name}", (Object)entity, Map.class, new Object[]{"v26.0", name});
    }

    public Map<String, Object> update(String sObjectName, String sObjectId, Map<String, Object> fields) {
        this.requireAuthorization();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(fields, (MultiValueMap)headers);
        HashMap<String, Object> result = (HashMap<String, Object>)this.restTemplate.postForObject(((Salesforce)this.api).getBaseUrl() + "/{version}/sobjects/{sObjectName}/{sObjectId}?_HttpMethod=PATCH", (Object)entity, Map.class, new Object[]{"v26.0", sObjectName, sObjectId});
        if (result == null) {
            result = new HashMap<String, Object>();
            result.put("id", sObjectId);
            result.put("success", true);
            result.put("errors", new ArrayList());
        }
        return result;
    }
}

