/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.api.impl;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.springframework.social.salesforce.api.QueryOperations;
import org.springframework.social.salesforce.api.QueryResult;
import org.springframework.social.salesforce.api.Salesforce;
import org.springframework.social.salesforce.api.impl.AbstractSalesForceOperations;
import org.springframework.social.support.URIBuilder;
import org.springframework.web.client.RestTemplate;

public class QueryTemplate
extends AbstractSalesForceOperations<Salesforce>
implements QueryOperations {
    private RestTemplate restTemplate;

    public QueryTemplate(Salesforce api, RestTemplate restTemplate) {
        super(api);
        this.restTemplate = restTemplate;
    }

    @Override
    public QueryResult query(String query) {
        this.requireAuthorization();
        URI uri = URIBuilder.fromUri((String)(((Salesforce)this.api).getBaseUrl() + "/" + "v26.0" + "/query")).queryParam("q", query).build();
        return (QueryResult)this.restTemplate.getForObject(uri, QueryResult.class);
    }

    @Override
    public QueryResult nextPage(String pathOrToken) {
        this.requireAuthorization();
        if (pathOrToken.contains("/")) {
            return (QueryResult)this.restTemplate.getForObject(((Salesforce)this.api).getInstanceUrl() + pathOrToken, QueryResult.class, new Object[0]);
        }
        return (QueryResult)this.restTemplate.getForObject(((Salesforce)this.api).getBaseUrl() + "/" + "v26.0" + "/query/{token}", QueryResult.class, new Object[]{pathOrToken});
    }

    @Override
    public QueryResult queryAll(String query) {
        QueryResult page = this.query(query);
        QueryResult results = new QueryResult(page.getTotalSize(), true);
        results.setRecords(page.getRecords());
        while (StringUtils.isNotBlank((CharSequence)page.getNextRecordsUrl())) {
            page = this.nextPage(page.getNextRecordsUrl());
            results.getRecords().addAll(page.getRecords());
        }
        return results;
    }
}

