/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import org.springframework.social.salesforce.api.ChatterOperations;
import org.springframework.social.salesforce.api.Salesforce;
import org.springframework.social.salesforce.api.SalesforceProfile;
import org.springframework.social.salesforce.api.Status;
import org.springframework.social.salesforce.api.impl.AbstractSalesForceOperations;
import org.springframework.social.salesforce.api.impl.HeaderAddingInterceptor;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ChatterTemplate
extends AbstractSalesForceOperations<Salesforce>
implements ChatterOperations {
    private RestTemplate restTemplate;

    public ChatterTemplate(Salesforce api, RestTemplate restTemplate) {
        super(api);
        this.restTemplate = restTemplate;
        this.restTemplate = this.addInterceptors(restTemplate);
    }

    @Override
    public SalesforceProfile getUserProfile() {
        return this.getUserProfile("me");
    }

    @Override
    public SalesforceProfile getUserProfile(String userId) {
        this.requireAuthorization();
        return (SalesforceProfile)this.restTemplate.getForObject(((Salesforce)this.api).getBaseUrl() + "/{version}/chatter/users/{id}", SalesforceProfile.class, new Object[]{"v23.0", userId});
    }

    @Override
    public Status getStatus() {
        return this.getStatus("me");
    }

    @Override
    public Status getStatus(String userId) {
        this.requireAuthorization();
        JsonNode node = (JsonNode)this.restTemplate.getForObject(((Salesforce)this.api).getBaseUrl() + "/{version}/chatter/users/{userId}/status", JsonNode.class, new Object[]{"v23.0", userId});
        return ((Salesforce)this.api).readObject(node.get("body"), Status.class);
    }

    @Override
    public Status updateStatus(String message) {
        return this.updateStatus("me", message);
    }

    @Override
    public Status updateStatus(String userId, String message) {
        this.requireAuthorization();
        LinkedMultiValueMap post = new LinkedMultiValueMap();
        post.add((Object)"text", (Object)message);
        JsonNode node = (JsonNode)this.restTemplate.postForObject(((Salesforce)this.api).getBaseUrl() + "/{version}/chatter/users/{userId}/status", (Object)post, JsonNode.class, new Object[]{"v23.0", userId});
        return ((Salesforce)this.api).readObject(node.get("body"), Status.class);
    }

    private RestTemplate addInterceptors(RestTemplate restTemplate) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Chatter-Entity-Encoding", "false");
        restTemplate.getInterceptors().add(new HeaderAddingInterceptor(headers));
        return restTemplate;
    }
}

