/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.BulkConnection;
import com.sforce.async.CSVReader;
import com.sforce.async.ContentType;
import com.sforce.async.JobInfo;
import com.sforce.async.JobStateEnum;
import com.sforce.async.OperationEnum;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.social.salesforce.api.ApiVersion;
import org.springframework.social.salesforce.api.BulkApiException;
import org.springframework.social.salesforce.api.BulkApiOperations;
import org.springframework.social.salesforce.api.Salesforce;
import org.springframework.social.salesforce.api.impl.AbstractSalesForceOperations;
import org.springframework.social.support.URIBuilder;
import org.springframework.web.client.RestTemplate;

public class BulkApiTemplate
extends AbstractSalesForceOperations<Salesforce>
implements BulkApiOperations {
    private final Logger logger = LoggerFactory.getLogger(BulkApiTemplate.class);
    private RestTemplate restTemplate;
    private String accessToken;
    private String apiVersion = "29.0";
    private boolean HTTP_DEBUGGING = false;
    private List<String> errors = new ArrayList<String>();

    public BulkApiTemplate(Salesforce api, RestTemplate restTemplate, String accessToken) {
        super(api);
        this.restTemplate = restTemplate;
        this.accessToken = accessToken;
    }

    @Override
    public List<ApiVersion> getVersions() {
        URI uri = URIBuilder.fromUri((String)((Salesforce)this.api).getBaseUrl()).build();
        JsonNode dataNode = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        return ((Salesforce)this.api).readList(dataNode, ApiVersion.class);
    }

    @Override
    public String doBulkOperation(String sObjectType, OperationEnum operation, File csvFile, boolean deleteCsvFile) throws BulkApiException {
        this.requireAuthorization();
        this.errors.clear();
        JsonNode node = (JsonNode)this.restTemplate.getForObject(((Salesforce)this.api).getIdentityServiceUrl(), JsonNode.class, new Object[0]);
        String soapEndpoint = (String)node.get("urls").findValuesAsText("enterprise").get(0);
        String bulkUrl = soapEndpoint.substring(0, soapEndpoint.indexOf("Soap/")) + "async/" + this.apiVersion;
        JobInfo jobInfo = new JobInfo();
        try {
            BulkConnection connection = this.getBulkConnection(bulkUrl);
            jobInfo = this.createJob(sObjectType, operation, connection);
            List<BatchInfo> batchInfoList = this.createBatchesFromCSVFile(connection, jobInfo, csvFile);
            this.closeJob(connection, jobInfo.getId());
            this.awaitCompletion(connection, jobInfo, batchInfoList);
            this.checkResults(connection, jobInfo, batchInfoList);
            if (deleteCsvFile) {
                csvFile.delete();
            }
        }
        catch (ConnectionException e) {
            throw new BulkApiException("Error connecting to bulk api: " + e.getMessage(), e);
        }
        catch (AsyncApiException e) {
            throw new BulkApiException("Bulk api exception: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BulkApiException("IO exception: " + e.getMessage(), e);
        }
        return jobInfo.getId();
    }

    @Override
    public String doBulkOperation(String sObjectType, OperationEnum operation, List<Map<String, Object>> records) throws BulkApiException {
        File csvFile;
        Writer writer = null;
        try {
            csvFile = File.createTempFile("sfBulkOperation", ".csv");
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(csvFile)));
            int i = 0;
            for (Map<String, Object> row : records) {
                if (i == 0) {
                    this.writeHeader(writer, row.keySet());
                    ++i;
                }
                this.writeData(writer, row);
            }
        }
        catch (IOException e) {
            throw new BulkApiException("IO exception creating csv file: " + e.getMessage(), e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new BulkApiException("IO exception closing writer: " + e.getMessage(), e);
            }
        }
        return this.doBulkOperation(sObjectType, operation, csvFile, true);
    }

    private void writeHeader(Writer writer, Set<String> keys) throws IOException {
        String header = "";
        for (String key : keys) {
            header = header + key + ",";
        }
        header = header.substring(0, header.lastIndexOf(",")) + "\n";
        writer.write(header);
    }

    private void writeData(Writer writer, Map<String, Object> map) throws IOException {
        Set<String> keys = map.keySet();
        String data = "";
        for (String key : keys) {
            data = data + map.get(key) + ",";
        }
        data = data.substring(0, data.lastIndexOf(",")) + "\n";
        writer.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BatchInfo> createBatchesFromCSVFile(BulkConnection connection, JobInfo jobInfo, File csvFile) throws IOException, AsyncApiException {
        this.logger.info("Creating batch job with jobId: {}", (Object)jobInfo.getId());
        ArrayList<BatchInfo> batchInfos = new ArrayList<BatchInfo>();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(new FileInputStream(csvFile)));
        byte[] headerBytes = (rdr.readLine() + "\n").getBytes("UTF-8");
        int headerBytesLength = headerBytes.length;
        File tmpFile = File.createTempFile("bulkAPIInsert", ".csv");
        try {
            String nextLine;
            FileOutputStream tmpOut = new FileOutputStream(tmpFile);
            int maxBytesPerBatch = 10000000;
            int maxRowsPerBatch = 10000;
            int currentBytes = 0;
            int currentLines = 0;
            while ((nextLine = rdr.readLine()) != null) {
                byte[] bytes = (nextLine + "\n").getBytes("UTF-8");
                if (currentBytes + bytes.length > maxBytesPerBatch || currentLines > maxRowsPerBatch) {
                    this.createBatch(tmpOut, tmpFile, batchInfos, connection, jobInfo);
                    currentBytes = 0;
                    currentLines = 0;
                }
                if (currentBytes == 0) {
                    tmpOut = new FileOutputStream(tmpFile);
                    tmpOut.write(headerBytes);
                    currentBytes = headerBytesLength;
                    currentLines = 1;
                }
                tmpOut.write(bytes);
                currentBytes += bytes.length;
                ++currentLines;
            }
            if (currentLines > 1) {
                this.createBatch(tmpOut, tmpFile, batchInfos, connection, jobInfo);
            }
        }
        finally {
            rdr.close();
            tmpFile.delete();
        }
        return batchInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBatch(FileOutputStream tmpOut, File tmpFile, List<BatchInfo> batchInfos, BulkConnection connection, JobInfo jobInfo) throws IOException, AsyncApiException {
        tmpOut.flush();
        tmpOut.close();
        try (FileInputStream tmpInputStream = new FileInputStream(tmpFile);){
            BatchInfo batchInfo = connection.createBatchFromStream(jobInfo, (InputStream)tmpInputStream);
            batchInfos.add(batchInfo);
        }
    }

    private BulkConnection getBulkConnection(String bulkUrl) throws ConnectionException, AsyncApiException {
        ConnectorConfig config = new ConnectorConfig();
        config.setSessionId(this.accessToken);
        config.setRestEndpoint(bulkUrl);
        config.setCompression(this.HTTP_DEBUGGING);
        config.setTraceMessage(this.HTTP_DEBUGGING);
        BulkConnection connection = new BulkConnection(config);
        return connection;
    }

    private JobInfo createJob(String sobjectType, OperationEnum operation, BulkConnection connection) throws AsyncApiException {
        JobInfo job = new JobInfo();
        job.setObject(sobjectType);
        job.setOperation(operation);
        job.setContentType(ContentType.CSV);
        job = connection.createJob(job);
        return job;
    }

    private void closeJob(BulkConnection connection, String jobId) throws AsyncApiException {
        JobInfo job = new JobInfo();
        job.setId(jobId);
        job.setState(JobStateEnum.Closed);
        connection.updateJob(job);
    }

    private void awaitCompletion(BulkConnection connection, JobInfo job, List<BatchInfo> batchInfoList) throws AsyncApiException {
        long sleepTime = 0L;
        HashSet<String> incomplete = new HashSet<String>();
        for (BatchInfo bi : batchInfoList) {
            incomplete.add(bi.getId());
        }
        while (!incomplete.isEmpty()) {
            BatchInfo[] statusList;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.logger.info("Awaiting results...{}}", (Object)incomplete.size());
            sleepTime = 10000L;
            for (BatchInfo b : statusList = connection.getBatchInfoList(job.getId()).getBatchInfo()) {
                if (b.getState() != BatchStateEnum.Completed && b.getState() != BatchStateEnum.Failed || !incomplete.remove(b.getId())) continue;
                this.logger.info("BATCH STATUS:\n{}", (Object)b);
            }
        }
    }

    private void checkResults(BulkConnection connection, JobInfo job, List<BatchInfo> batchInfoList) throws AsyncApiException, IOException, BulkApiException {
        for (BatchInfo b : batchInfoList) {
            ArrayList row;
            CSVReader rdr = new CSVReader(connection.getBatchResultStream(job.getId(), b.getId()));
            ArrayList resultHeader = rdr.nextRecord();
            int resultCols = resultHeader.size();
            while ((row = rdr.nextRecord()) != null) {
                HashMap resultInfo = new HashMap();
                for (int i = 0; i < resultCols; ++i) {
                    resultInfo.put(resultHeader.get(i), row.get(i));
                }
                boolean success = Boolean.valueOf((String)resultInfo.get("Success"));
                String id = (String)resultInfo.get("Id");
                String error = (String)resultInfo.get("Error");
                if (success) continue;
                String message = "Row with Id: " + id + " failed with error: " + error;
                this.errors.add(message);
                this.logger.error(message);
            }
            if (this.errors.isEmpty()) continue;
            throw new BulkApiException("Row errors occurred during bulk operation - JobId: " + job.getId(), this.errors);
        }
    }
}

