/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.salesforce.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.social.salesforce.api.ApiOperations;
import org.springframework.social.salesforce.api.ApiVersion;
import org.springframework.social.salesforce.api.Salesforce;
import org.springframework.social.salesforce.api.impl.AbstractSalesForceOperations;
import org.springframework.social.support.URIBuilder;
import org.springframework.web.client.RestTemplate;

public class ApiTemplate
extends AbstractSalesForceOperations<Salesforce>
implements ApiOperations {
    private RestTemplate restTemplate;

    public ApiTemplate(Salesforce api, RestTemplate restTemplate) {
        super(api);
        this.restTemplate = restTemplate;
    }

    @Override
    public List<ApiVersion> getVersions() {
        URI uri = URIBuilder.fromUri((String)((Salesforce)this.api).getBaseUrl()).build();
        JsonNode dataNode = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        return ((Salesforce)this.api).readList(dataNode, ApiVersion.class);
    }

    @Override
    public Map<String, String> getServices(String version) {
        this.requireAuthorization();
        return (Map)this.restTemplate.getForObject(((Salesforce)this.api).getBaseUrl() + "/v{version}", Map.class, new Object[]{version});
    }
}

