/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.support;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.connect.support.RefreshingOAuth2Connection;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.OAuth2ServiceProvider;

public class RefreshingOAuth2ConnectionFactory<S>
extends OAuth2ConnectionFactory<S> {
    public RefreshingOAuth2ConnectionFactory(String providerId, OAuth2ServiceProvider<S> soAuth2ServiceProvider, ApiAdapter<S> sApiAdapter) {
        super(providerId, soAuth2ServiceProvider, sApiAdapter);
    }

    public Connection<S> createConnection(AccessGrant accessGrant) {
        return new RefreshingOAuth2Connection(this.getProviderId(), this.extractProviderUserId(accessGrant), accessGrant.getAccessToken(), accessGrant.getRefreshToken(), accessGrant.getExpireTime(), (OAuth2ServiceProvider)this.getServiceProvider(), this.getApiAdapter());
    }

    public Connection<S> createConnection(ConnectionData data) {
        return new RefreshingOAuth2Connection(data, (OAuth2ServiceProvider)this.getServiceProvider(), this.getApiAdapter());
    }
}

