package org.springframework.social.salesforce.api.impl;

import java.net.URI;
import java.util.List;

import org.springframework.social.salesforce.api.ResultItem;
import org.springframework.social.salesforce.api.Salesforce;
import org.springframework.social.salesforce.api.SearchOperations;
import org.springframework.social.support.URIBuilder;
import org.springframework.web.client.RestTemplate;

import com.fasterxml.jackson.databind.JsonNode;

/**
 * Default implementation of SearchOperations.
 * 
 * @author Umut Utkan
 */
public class SearchTemplate extends AbstractSalesForceOperations<Salesforce> implements SearchOperations {

    private RestTemplate restTemplate;

    public SearchTemplate(Salesforce api, RestTemplate restTemplate) {
        super(api);
        this.restTemplate = restTemplate;
    }

    /**
     * @see org.springframework.social.salesforce.api.SearchOperations#search(java.lang.String)
     */
    @Override
    public List<ResultItem> search(String soslQuery) {
        requireAuthorization();
        URI uri = URIBuilder.fromUri(api.getBaseUrl() + "/" + API_VERSION + "/search").queryParam("q", soslQuery).build();
        JsonNode arr = restTemplate.getForObject(uri, JsonNode.class);
        return api.readList(arr, ResultItem.class);
    }

}
