/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Ch34xSerialDriver
implements UsbSerialDriver {
    private static final String TAG = Ch34xSerialDriver.class.getSimpleName();
    private final UsbDevice mDevice;
    private final UsbSerialPort mPort;
    private static final int LCR_ENABLE_RX = 128;
    private static final int LCR_ENABLE_TX = 64;
    private static final int LCR_MARK_SPACE = 32;
    private static final int LCR_PAR_EVEN = 16;
    private static final int LCR_ENABLE_PAR = 8;
    private static final int LCR_STOP_BITS_2 = 4;
    private static final int LCR_CS8 = 3;
    private static final int LCR_CS7 = 2;
    private static final int LCR_CS6 = 1;
    private static final int LCR_CS5 = 0;

    public Ch34xSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPort = new Ch340SerialPort(this.mDevice, 0);
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return Collections.singletonList(this.mPort);
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(6790, new int[]{29987});
        return supportedDevices;
    }

    public class Ch340SerialPort
    extends CommonUsbSerialPort {
        private static final int USB_TIMEOUT_MILLIS = 5000;
        private final int DEFAULT_BAUD_RATE = 9600;
        private boolean dtr;
        private boolean rts;

        public Ch340SerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.DEFAULT_BAUD_RATE = 9600;
            this.dtr = false;
            this.rts = false;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return Ch34xSerialDriver.this;
        }

        @Override
        public void openInt(UsbDeviceConnection connection) throws IOException {
            for (int i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                UsbInterface usbIface = this.mDevice.getInterface(i);
                if (this.mConnection.claimInterface(usbIface, true)) continue;
                throw new IOException("Could not claim data interface");
            }
            UsbInterface dataIface = this.mDevice.getInterface(this.mDevice.getInterfaceCount() - 1);
            for (int i = 0; i < dataIface.getEndpointCount(); ++i) {
                UsbEndpoint ep = dataIface.getEndpoint(i);
                if (ep.getType() != 2) continue;
                if (ep.getDirection() == 128) {
                    this.mReadEndpoint = ep;
                    continue;
                }
                this.mWriteEndpoint = ep;
            }
            this.initialize();
            this.setBaudRate(9600);
        }

        @Override
        public void closeInt() {
            try {
                for (int i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                    this.mConnection.releaseInterface(this.mDevice.getInterface(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int controlOut(int request, int value, int index) {
            int REQTYPE_HOST_TO_DEVICE = 64;
            return this.mConnection.controlTransfer(64, request, value, index, null, 0, 5000);
        }

        private int controlIn(int request, int value, int index, byte[] buffer) {
            int REQTYPE_DEVICE_TO_HOST = 192;
            return this.mConnection.controlTransfer(192, request, value, index, buffer, buffer.length, 5000);
        }

        private void checkState(String msg, int request, int value, int[] expected) throws IOException {
            byte[] buffer = new byte[expected.length];
            int ret = this.controlIn(request, value, 0, buffer);
            if (ret < 0) {
                throw new IOException("Faild send cmd [" + msg + "]");
            }
            if (ret != expected.length) {
                throw new IOException("Expected " + expected.length + " bytes, but get " + ret + " [" + msg + "]");
            }
            for (int i = 0; i < expected.length; ++i) {
                int current;
                if (expected[i] == -1 || expected[i] == (current = buffer[i] & 0xFF)) continue;
                throw new IOException("Expected 0x" + Integer.toHexString(expected[i]) + " bytes, but get 0x" + Integer.toHexString(current) + " [" + msg + "]");
            }
        }

        private void writeHandshakeByte() throws IOException {
            if (this.controlOut(164, ~((this.dtr ? 32 : 0) | (this.rts ? 64 : 0)), 0) < 0) {
                throw new IOException("Faild to set handshake byte");
            }
        }

        private void initialize() throws IOException {
            this.checkState("init #1", 95, 0, new int[]{-1, 0});
            if (this.controlOut(161, 0, 0) < 0) {
                throw new IOException("Init failed: #2");
            }
            this.setBaudRate(9600);
            this.checkState("init #4", 149, 9496, new int[]{-1, 0});
            if (this.controlOut(154, 9496, 195) < 0) {
                throw new IOException("Init failed: #5");
            }
            this.checkState("init #6", 149, 1798, new int[]{255, 238});
            if (this.controlOut(161, 20511, 55562) < 0) {
                throw new IOException("Init failed: #7");
            }
            this.setBaudRate(9600);
            this.writeHandshakeByte();
            this.checkState("init #10", 149, 1798, new int[]{-1, 238});
        }

        private void setBaudRate(int baudRate) throws IOException {
            int divisor;
            long CH341_BAUDBASE_FACTOR = 1532620800L;
            int CH341_BAUDBASE_DIVMAX = 3;
            long factor = 1532620800L / (long)baudRate;
            for (divisor = 3; factor > 65520L && divisor > 0; factor >>= 3, --divisor) {
            }
            if (factor > 65520L) {
                throw new UnsupportedOperationException("Unsupported baud rate: " + baudRate);
            }
            int ret = this.controlOut(154, 4882, (int)((factor = 65536L - factor) & 0xFF00L | (long)divisor));
            if (ret < 0) {
                throw new IOException("Error setting baud rate: #1)");
            }
            ret = this.controlOut(154, 3884, (int)(factor & 0xFFL));
            if (ret < 0) {
                throw new IOException("Error setting baud rate: #2");
            }
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            if (baudRate <= 0) {
                throw new IllegalArgumentException("Invalid baud rate: " + baudRate);
            }
            this.setBaudRate(baudRate);
            int lcr = 192;
            switch (dataBits) {
                case 5: {
                    lcr |= 0;
                    break;
                }
                case 6: {
                    lcr |= 1;
                    break;
                }
                case 7: {
                    lcr |= 2;
                    break;
                }
                case 8: {
                    lcr |= 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid data bits: " + dataBits);
                }
            }
            switch (parity) {
                case 0: {
                    break;
                }
                case 1: {
                    lcr |= 8;
                    break;
                }
                case 2: {
                    lcr |= 0x18;
                    break;
                }
                case 3: {
                    lcr |= 0x28;
                    break;
                }
                case 4: {
                    lcr |= 0x38;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid parity: " + parity);
                }
            }
            switch (stopBits) {
                case 1: {
                    break;
                }
                case 3: {
                    throw new UnsupportedOperationException("Unsupported stop bits: 1.5");
                }
                case 2: {
                    lcr |= 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid stop bits: " + stopBits);
                }
            }
            int ret = this.controlOut(154, 9496, lcr);
            if (ret < 0) {
                throw new IOException("Error setting control byte");
            }
        }

        @Override
        public boolean getCD() throws IOException {
            return false;
        }

        @Override
        public boolean getCTS() throws IOException {
            return false;
        }

        @Override
        public boolean getDSR() throws IOException {
            return false;
        }

        @Override
        public boolean getDTR() throws IOException {
            return this.dtr;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
            this.dtr = value;
            this.writeHandshakeByte();
        }

        @Override
        public boolean getRI() throws IOException {
            return false;
        }

        @Override
        public boolean getRTS() throws IOException {
            return this.rts;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
            this.rts = value;
            this.writeHandshakeByte();
        }
    }
}

